import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  /* config options here */
  reactCompiler: true,
  // Use 'standalone' for VPS/Docker, remove for Vercel
  // output: 'standalone',
  experimental: {
    optimizePackageImports: ['@heroicons/react', 'framer-motion'],
  },
  // Suppress hydration warnings for browser extension compatibility
  compiler: {
    removeConsole: process.env.NODE_ENV === 'production',
  },
  // Image optimization for production
  images: {
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 'nuwair.com',
      },
      {
        protocol: 'https',
        hostname: '*.nuwair.com',
      },
    ],
    unoptimized: process.env.NODE_ENV === 'development',
  },
};

export default nextConfig;
