import { type HostHeaderInputConfig, type HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { type UserAgentInputConfig, type UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { type RegionInputConfig, type RegionResolvedConfig } from "@smithy/config-resolver";
import { type EndpointInputConfig, type EndpointResolvedConfig } from "@smithy/middleware-endpoint";
import { type RetryInputConfig, type RetryResolvedConfig } from "@smithy/middleware-retry";
import type { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import { type DefaultsMode as __DefaultsMode, type SmithyConfiguration as __SmithyConfiguration, type SmithyResolvedConfiguration as __SmithyResolvedConfiguration, Client as __Client } from "@smithy/smithy-client";
import { type BodyLengthCalculator as __BodyLengthCalculator, type CheckOptionalClientConfig as __CheckOptionalClientConfig, type ChecksumConstructor as __ChecksumConstructor, type ClientProtocol, type Decoder as __Decoder, type Encoder as __Encoder, type HashConstructor as __HashConstructor, type HttpHandlerOptions as __HttpHandlerOptions, type HttpRequest, type HttpResponse, type Logger as __Logger, type Provider as __Provider, type StreamCollector as __StreamCollector, type UrlParser as __UrlParser, AwsCredentialIdentityProvider, Provider, UserAgent as __UserAgent } from "@smithy/types";
import { type HttpAuthSchemeInputConfig, type HttpAuthSchemeResolvedConfig } from "./auth/httpAuthSchemeProvider";
import { BatchGetMetricDataCommandInput, BatchGetMetricDataCommandOutput } from "./commands/BatchGetMetricDataCommand";
import { CancelExportJobCommandInput, CancelExportJobCommandOutput } from "./commands/CancelExportJobCommand";
import { CreateConfigurationSetCommandInput, CreateConfigurationSetCommandOutput } from "./commands/CreateConfigurationSetCommand";
import { CreateConfigurationSetEventDestinationCommandInput, CreateConfigurationSetEventDestinationCommandOutput } from "./commands/CreateConfigurationSetEventDestinationCommand";
import { CreateContactCommandInput, CreateContactCommandOutput } from "./commands/CreateContactCommand";
import { CreateContactListCommandInput, CreateContactListCommandOutput } from "./commands/CreateContactListCommand";
import { CreateCustomVerificationEmailTemplateCommandInput, CreateCustomVerificationEmailTemplateCommandOutput } from "./commands/CreateCustomVerificationEmailTemplateCommand";
import { CreateDedicatedIpPoolCommandInput, CreateDedicatedIpPoolCommandOutput } from "./commands/CreateDedicatedIpPoolCommand";
import { CreateDeliverabilityTestReportCommandInput, CreateDeliverabilityTestReportCommandOutput } from "./commands/CreateDeliverabilityTestReportCommand";
import { CreateEmailIdentityCommandInput, CreateEmailIdentityCommandOutput } from "./commands/CreateEmailIdentityCommand";
import { CreateEmailIdentityPolicyCommandInput, CreateEmailIdentityPolicyCommandOutput } from "./commands/CreateEmailIdentityPolicyCommand";
import { CreateEmailTemplateCommandInput, CreateEmailTemplateCommandOutput } from "./commands/CreateEmailTemplateCommand";
import { CreateExportJobCommandInput, CreateExportJobCommandOutput } from "./commands/CreateExportJobCommand";
import { CreateImportJobCommandInput, CreateImportJobCommandOutput } from "./commands/CreateImportJobCommand";
import { CreateMultiRegionEndpointCommandInput, CreateMultiRegionEndpointCommandOutput } from "./commands/CreateMultiRegionEndpointCommand";
import { CreateTenantCommandInput, CreateTenantCommandOutput } from "./commands/CreateTenantCommand";
import { CreateTenantResourceAssociationCommandInput, CreateTenantResourceAssociationCommandOutput } from "./commands/CreateTenantResourceAssociationCommand";
import { DeleteConfigurationSetCommandInput, DeleteConfigurationSetCommandOutput } from "./commands/DeleteConfigurationSetCommand";
import { DeleteConfigurationSetEventDestinationCommandInput, DeleteConfigurationSetEventDestinationCommandOutput } from "./commands/DeleteConfigurationSetEventDestinationCommand";
import { DeleteContactCommandInput, DeleteContactCommandOutput } from "./commands/DeleteContactCommand";
import { DeleteContactListCommandInput, DeleteContactListCommandOutput } from "./commands/DeleteContactListCommand";
import { DeleteCustomVerificationEmailTemplateCommandInput, DeleteCustomVerificationEmailTemplateCommandOutput } from "./commands/DeleteCustomVerificationEmailTemplateCommand";
import { DeleteDedicatedIpPoolCommandInput, DeleteDedicatedIpPoolCommandOutput } from "./commands/DeleteDedicatedIpPoolCommand";
import { DeleteEmailIdentityCommandInput, DeleteEmailIdentityCommandOutput } from "./commands/DeleteEmailIdentityCommand";
import { DeleteEmailIdentityPolicyCommandInput, DeleteEmailIdentityPolicyCommandOutput } from "./commands/DeleteEmailIdentityPolicyCommand";
import { DeleteEmailTemplateCommandInput, DeleteEmailTemplateCommandOutput } from "./commands/DeleteEmailTemplateCommand";
import { DeleteMultiRegionEndpointCommandInput, DeleteMultiRegionEndpointCommandOutput } from "./commands/DeleteMultiRegionEndpointCommand";
import { DeleteSuppressedDestinationCommandInput, DeleteSuppressedDestinationCommandOutput } from "./commands/DeleteSuppressedDestinationCommand";
import { DeleteTenantCommandInput, DeleteTenantCommandOutput } from "./commands/DeleteTenantCommand";
import { DeleteTenantResourceAssociationCommandInput, DeleteTenantResourceAssociationCommandOutput } from "./commands/DeleteTenantResourceAssociationCommand";
import { GetAccountCommandInput, GetAccountCommandOutput } from "./commands/GetAccountCommand";
import { GetBlacklistReportsCommandInput, GetBlacklistReportsCommandOutput } from "./commands/GetBlacklistReportsCommand";
import { GetConfigurationSetCommandInput, GetConfigurationSetCommandOutput } from "./commands/GetConfigurationSetCommand";
import { GetConfigurationSetEventDestinationsCommandInput, GetConfigurationSetEventDestinationsCommandOutput } from "./commands/GetConfigurationSetEventDestinationsCommand";
import { GetContactCommandInput, GetContactCommandOutput } from "./commands/GetContactCommand";
import { GetContactListCommandInput, GetContactListCommandOutput } from "./commands/GetContactListCommand";
import { GetCustomVerificationEmailTemplateCommandInput, GetCustomVerificationEmailTemplateCommandOutput } from "./commands/GetCustomVerificationEmailTemplateCommand";
import { GetDedicatedIpCommandInput, GetDedicatedIpCommandOutput } from "./commands/GetDedicatedIpCommand";
import { GetDedicatedIpPoolCommandInput, GetDedicatedIpPoolCommandOutput } from "./commands/GetDedicatedIpPoolCommand";
import { GetDedicatedIpsCommandInput, GetDedicatedIpsCommandOutput } from "./commands/GetDedicatedIpsCommand";
import { GetDeliverabilityDashboardOptionsCommandInput, GetDeliverabilityDashboardOptionsCommandOutput } from "./commands/GetDeliverabilityDashboardOptionsCommand";
import { GetDeliverabilityTestReportCommandInput, GetDeliverabilityTestReportCommandOutput } from "./commands/GetDeliverabilityTestReportCommand";
import { GetDomainDeliverabilityCampaignCommandInput, GetDomainDeliverabilityCampaignCommandOutput } from "./commands/GetDomainDeliverabilityCampaignCommand";
import { GetDomainStatisticsReportCommandInput, GetDomainStatisticsReportCommandOutput } from "./commands/GetDomainStatisticsReportCommand";
import { GetEmailIdentityCommandInput, GetEmailIdentityCommandOutput } from "./commands/GetEmailIdentityCommand";
import { GetEmailIdentityPoliciesCommandInput, GetEmailIdentityPoliciesCommandOutput } from "./commands/GetEmailIdentityPoliciesCommand";
import { GetEmailTemplateCommandInput, GetEmailTemplateCommandOutput } from "./commands/GetEmailTemplateCommand";
import { GetExportJobCommandInput, GetExportJobCommandOutput } from "./commands/GetExportJobCommand";
import { GetImportJobCommandInput, GetImportJobCommandOutput } from "./commands/GetImportJobCommand";
import { GetMessageInsightsCommandInput, GetMessageInsightsCommandOutput } from "./commands/GetMessageInsightsCommand";
import { GetMultiRegionEndpointCommandInput, GetMultiRegionEndpointCommandOutput } from "./commands/GetMultiRegionEndpointCommand";
import { GetReputationEntityCommandInput, GetReputationEntityCommandOutput } from "./commands/GetReputationEntityCommand";
import { GetSuppressedDestinationCommandInput, GetSuppressedDestinationCommandOutput } from "./commands/GetSuppressedDestinationCommand";
import { GetTenantCommandInput, GetTenantCommandOutput } from "./commands/GetTenantCommand";
import { ListConfigurationSetsCommandInput, ListConfigurationSetsCommandOutput } from "./commands/ListConfigurationSetsCommand";
import { ListContactListsCommandInput, ListContactListsCommandOutput } from "./commands/ListContactListsCommand";
import { ListContactsCommandInput, ListContactsCommandOutput } from "./commands/ListContactsCommand";
import { ListCustomVerificationEmailTemplatesCommandInput, ListCustomVerificationEmailTemplatesCommandOutput } from "./commands/ListCustomVerificationEmailTemplatesCommand";
import { ListDedicatedIpPoolsCommandInput, ListDedicatedIpPoolsCommandOutput } from "./commands/ListDedicatedIpPoolsCommand";
import { ListDeliverabilityTestReportsCommandInput, ListDeliverabilityTestReportsCommandOutput } from "./commands/ListDeliverabilityTestReportsCommand";
import { ListDomainDeliverabilityCampaignsCommandInput, ListDomainDeliverabilityCampaignsCommandOutput } from "./commands/ListDomainDeliverabilityCampaignsCommand";
import { ListEmailIdentitiesCommandInput, ListEmailIdentitiesCommandOutput } from "./commands/ListEmailIdentitiesCommand";
import { ListEmailTemplatesCommandInput, ListEmailTemplatesCommandOutput } from "./commands/ListEmailTemplatesCommand";
import { ListExportJobsCommandInput, ListExportJobsCommandOutput } from "./commands/ListExportJobsCommand";
import { ListImportJobsCommandInput, ListImportJobsCommandOutput } from "./commands/ListImportJobsCommand";
import { ListMultiRegionEndpointsCommandInput, ListMultiRegionEndpointsCommandOutput } from "./commands/ListMultiRegionEndpointsCommand";
import { ListRecommendationsCommandInput, ListRecommendationsCommandOutput } from "./commands/ListRecommendationsCommand";
import { ListReputationEntitiesCommandInput, ListReputationEntitiesCommandOutput } from "./commands/ListReputationEntitiesCommand";
import { ListResourceTenantsCommandInput, ListResourceTenantsCommandOutput } from "./commands/ListResourceTenantsCommand";
import { ListSuppressedDestinationsCommandInput, ListSuppressedDestinationsCommandOutput } from "./commands/ListSuppressedDestinationsCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { ListTenantResourcesCommandInput, ListTenantResourcesCommandOutput } from "./commands/ListTenantResourcesCommand";
import { ListTenantsCommandInput, ListTenantsCommandOutput } from "./commands/ListTenantsCommand";
import { PutAccountDedicatedIpWarmupAttributesCommandInput, PutAccountDedicatedIpWarmupAttributesCommandOutput } from "./commands/PutAccountDedicatedIpWarmupAttributesCommand";
import { PutAccountDetailsCommandInput, PutAccountDetailsCommandOutput } from "./commands/PutAccountDetailsCommand";
import { PutAccountSendingAttributesCommandInput, PutAccountSendingAttributesCommandOutput } from "./commands/PutAccountSendingAttributesCommand";
import { PutAccountSuppressionAttributesCommandInput, PutAccountSuppressionAttributesCommandOutput } from "./commands/PutAccountSuppressionAttributesCommand";
import { PutAccountVdmAttributesCommandInput, PutAccountVdmAttributesCommandOutput } from "./commands/PutAccountVdmAttributesCommand";
import { PutConfigurationSetArchivingOptionsCommandInput, PutConfigurationSetArchivingOptionsCommandOutput } from "./commands/PutConfigurationSetArchivingOptionsCommand";
import { PutConfigurationSetDeliveryOptionsCommandInput, PutConfigurationSetDeliveryOptionsCommandOutput } from "./commands/PutConfigurationSetDeliveryOptionsCommand";
import { PutConfigurationSetReputationOptionsCommandInput, PutConfigurationSetReputationOptionsCommandOutput } from "./commands/PutConfigurationSetReputationOptionsCommand";
import { PutConfigurationSetSendingOptionsCommandInput, PutConfigurationSetSendingOptionsCommandOutput } from "./commands/PutConfigurationSetSendingOptionsCommand";
import { PutConfigurationSetSuppressionOptionsCommandInput, PutConfigurationSetSuppressionOptionsCommandOutput } from "./commands/PutConfigurationSetSuppressionOptionsCommand";
import { PutConfigurationSetTrackingOptionsCommandInput, PutConfigurationSetTrackingOptionsCommandOutput } from "./commands/PutConfigurationSetTrackingOptionsCommand";
import { PutConfigurationSetVdmOptionsCommandInput, PutConfigurationSetVdmOptionsCommandOutput } from "./commands/PutConfigurationSetVdmOptionsCommand";
import { PutDedicatedIpInPoolCommandInput, PutDedicatedIpInPoolCommandOutput } from "./commands/PutDedicatedIpInPoolCommand";
import { PutDedicatedIpPoolScalingAttributesCommandInput, PutDedicatedIpPoolScalingAttributesCommandOutput } from "./commands/PutDedicatedIpPoolScalingAttributesCommand";
import { PutDedicatedIpWarmupAttributesCommandInput, PutDedicatedIpWarmupAttributesCommandOutput } from "./commands/PutDedicatedIpWarmupAttributesCommand";
import { PutDeliverabilityDashboardOptionCommandInput, PutDeliverabilityDashboardOptionCommandOutput } from "./commands/PutDeliverabilityDashboardOptionCommand";
import { PutEmailIdentityConfigurationSetAttributesCommandInput, PutEmailIdentityConfigurationSetAttributesCommandOutput } from "./commands/PutEmailIdentityConfigurationSetAttributesCommand";
import { PutEmailIdentityDkimAttributesCommandInput, PutEmailIdentityDkimAttributesCommandOutput } from "./commands/PutEmailIdentityDkimAttributesCommand";
import { PutEmailIdentityDkimSigningAttributesCommandInput, PutEmailIdentityDkimSigningAttributesCommandOutput } from "./commands/PutEmailIdentityDkimSigningAttributesCommand";
import { PutEmailIdentityFeedbackAttributesCommandInput, PutEmailIdentityFeedbackAttributesCommandOutput } from "./commands/PutEmailIdentityFeedbackAttributesCommand";
import { PutEmailIdentityMailFromAttributesCommandInput, PutEmailIdentityMailFromAttributesCommandOutput } from "./commands/PutEmailIdentityMailFromAttributesCommand";
import { PutSuppressedDestinationCommandInput, PutSuppressedDestinationCommandOutput } from "./commands/PutSuppressedDestinationCommand";
import { SendBulkEmailCommandInput, SendBulkEmailCommandOutput } from "./commands/SendBulkEmailCommand";
import { SendCustomVerificationEmailCommandInput, SendCustomVerificationEmailCommandOutput } from "./commands/SendCustomVerificationEmailCommand";
import { SendEmailCommandInput, SendEmailCommandOutput } from "./commands/SendEmailCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { TestRenderEmailTemplateCommandInput, TestRenderEmailTemplateCommandOutput } from "./commands/TestRenderEmailTemplateCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateConfigurationSetEventDestinationCommandInput, UpdateConfigurationSetEventDestinationCommandOutput } from "./commands/UpdateConfigurationSetEventDestinationCommand";
import { UpdateContactCommandInput, UpdateContactCommandOutput } from "./commands/UpdateContactCommand";
import { UpdateContactListCommandInput, UpdateContactListCommandOutput } from "./commands/UpdateContactListCommand";
import { UpdateCustomVerificationEmailTemplateCommandInput, UpdateCustomVerificationEmailTemplateCommandOutput } from "./commands/UpdateCustomVerificationEmailTemplateCommand";
import { UpdateEmailIdentityPolicyCommandInput, UpdateEmailIdentityPolicyCommandOutput } from "./commands/UpdateEmailIdentityPolicyCommand";
import { UpdateEmailTemplateCommandInput, UpdateEmailTemplateCommandOutput } from "./commands/UpdateEmailTemplateCommand";
import { UpdateReputationEntityCustomerManagedStatusCommandInput, UpdateReputationEntityCustomerManagedStatusCommandOutput } from "./commands/UpdateReputationEntityCustomerManagedStatusCommand";
import { UpdateReputationEntityPolicyCommandInput, UpdateReputationEntityPolicyCommandOutput } from "./commands/UpdateReputationEntityPolicyCommand";
import { ClientInputEndpointParameters, ClientResolvedEndpointParameters, EndpointParameters } from "./endpoint/EndpointParameters";
import { type RuntimeExtension, type RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
/**
 * @public
 */
export type ServiceInputTypes = BatchGetMetricDataCommandInput | CancelExportJobCommandInput | CreateConfigurationSetCommandInput | CreateConfigurationSetEventDestinationCommandInput | CreateContactCommandInput | CreateContactListCommandInput | CreateCustomVerificationEmailTemplateCommandInput | CreateDedicatedIpPoolCommandInput | CreateDeliverabilityTestReportCommandInput | CreateEmailIdentityCommandInput | CreateEmailIdentityPolicyCommandInput | CreateEmailTemplateCommandInput | CreateExportJobCommandInput | CreateImportJobCommandInput | CreateMultiRegionEndpointCommandInput | CreateTenantCommandInput | CreateTenantResourceAssociationCommandInput | DeleteConfigurationSetCommandInput | DeleteConfigurationSetEventDestinationCommandInput | DeleteContactCommandInput | DeleteContactListCommandInput | DeleteCustomVerificationEmailTemplateCommandInput | DeleteDedicatedIpPoolCommandInput | DeleteEmailIdentityCommandInput | DeleteEmailIdentityPolicyCommandInput | DeleteEmailTemplateCommandInput | DeleteMultiRegionEndpointCommandInput | DeleteSuppressedDestinationCommandInput | DeleteTenantCommandInput | DeleteTenantResourceAssociationCommandInput | GetAccountCommandInput | GetBlacklistReportsCommandInput | GetConfigurationSetCommandInput | GetConfigurationSetEventDestinationsCommandInput | GetContactCommandInput | GetContactListCommandInput | GetCustomVerificationEmailTemplateCommandInput | GetDedicatedIpCommandInput | GetDedicatedIpPoolCommandInput | GetDedicatedIpsCommandInput | GetDeliverabilityDashboardOptionsCommandInput | GetDeliverabilityTestReportCommandInput | GetDomainDeliverabilityCampaignCommandInput | GetDomainStatisticsReportCommandInput | GetEmailIdentityCommandInput | GetEmailIdentityPoliciesCommandInput | GetEmailTemplateCommandInput | GetExportJobCommandInput | GetImportJobCommandInput | GetMessageInsightsCommandInput | GetMultiRegionEndpointCommandInput | GetReputationEntityCommandInput | GetSuppressedDestinationCommandInput | GetTenantCommandInput | ListConfigurationSetsCommandInput | ListContactListsCommandInput | ListContactsCommandInput | ListCustomVerificationEmailTemplatesCommandInput | ListDedicatedIpPoolsCommandInput | ListDeliverabilityTestReportsCommandInput | ListDomainDeliverabilityCampaignsCommandInput | ListEmailIdentitiesCommandInput | ListEmailTemplatesCommandInput | ListExportJobsCommandInput | ListImportJobsCommandInput | ListMultiRegionEndpointsCommandInput | ListRecommendationsCommandInput | ListReputationEntitiesCommandInput | ListResourceTenantsCommandInput | ListSuppressedDestinationsCommandInput | ListTagsForResourceCommandInput | ListTenantResourcesCommandInput | ListTenantsCommandInput | PutAccountDedicatedIpWarmupAttributesCommandInput | PutAccountDetailsCommandInput | PutAccountSendingAttributesCommandInput | PutAccountSuppressionAttributesCommandInput | PutAccountVdmAttributesCommandInput | PutConfigurationSetArchivingOptionsCommandInput | PutConfigurationSetDeliveryOptionsCommandInput | PutConfigurationSetReputationOptionsCommandInput | PutConfigurationSetSendingOptionsCommandInput | PutConfigurationSetSuppressionOptionsCommandInput | PutConfigurationSetTrackingOptionsCommandInput | PutConfigurationSetVdmOptionsCommandInput | PutDedicatedIpInPoolCommandInput | PutDedicatedIpPoolScalingAttributesCommandInput | PutDedicatedIpWarmupAttributesCommandInput | PutDeliverabilityDashboardOptionCommandInput | PutEmailIdentityConfigurationSetAttributesCommandInput | PutEmailIdentityDkimAttributesCommandInput | PutEmailIdentityDkimSigningAttributesCommandInput | PutEmailIdentityFeedbackAttributesCommandInput | PutEmailIdentityMailFromAttributesCommandInput | PutSuppressedDestinationCommandInput | SendBulkEmailCommandInput | SendCustomVerificationEmailCommandInput | SendEmailCommandInput | TagResourceCommandInput | TestRenderEmailTemplateCommandInput | UntagResourceCommandInput | UpdateConfigurationSetEventDestinationCommandInput | UpdateContactCommandInput | UpdateContactListCommandInput | UpdateCustomVerificationEmailTemplateCommandInput | UpdateEmailIdentityPolicyCommandInput | UpdateEmailTemplateCommandInput | UpdateReputationEntityCustomerManagedStatusCommandInput | UpdateReputationEntityPolicyCommandInput;
/**
 * @public
 */
export type ServiceOutputTypes = BatchGetMetricDataCommandOutput | CancelExportJobCommandOutput | CreateConfigurationSetCommandOutput | CreateConfigurationSetEventDestinationCommandOutput | CreateContactCommandOutput | CreateContactListCommandOutput | CreateCustomVerificationEmailTemplateCommandOutput | CreateDedicatedIpPoolCommandOutput | CreateDeliverabilityTestReportCommandOutput | CreateEmailIdentityCommandOutput | CreateEmailIdentityPolicyCommandOutput | CreateEmailTemplateCommandOutput | CreateExportJobCommandOutput | CreateImportJobCommandOutput | CreateMultiRegionEndpointCommandOutput | CreateTenantCommandOutput | CreateTenantResourceAssociationCommandOutput | DeleteConfigurationSetCommandOutput | DeleteConfigurationSetEventDestinationCommandOutput | DeleteContactCommandOutput | DeleteContactListCommandOutput | DeleteCustomVerificationEmailTemplateCommandOutput | DeleteDedicatedIpPoolCommandOutput | DeleteEmailIdentityCommandOutput | DeleteEmailIdentityPolicyCommandOutput | DeleteEmailTemplateCommandOutput | DeleteMultiRegionEndpointCommandOutput | DeleteSuppressedDestinationCommandOutput | DeleteTenantCommandOutput | DeleteTenantResourceAssociationCommandOutput | GetAccountCommandOutput | GetBlacklistReportsCommandOutput | GetConfigurationSetCommandOutput | GetConfigurationSetEventDestinationsCommandOutput | GetContactCommandOutput | GetContactListCommandOutput | GetCustomVerificationEmailTemplateCommandOutput | GetDedicatedIpCommandOutput | GetDedicatedIpPoolCommandOutput | GetDedicatedIpsCommandOutput | GetDeliverabilityDashboardOptionsCommandOutput | GetDeliverabilityTestReportCommandOutput | GetDomainDeliverabilityCampaignCommandOutput | GetDomainStatisticsReportCommandOutput | GetEmailIdentityCommandOutput | GetEmailIdentityPoliciesCommandOutput | GetEmailTemplateCommandOutput | GetExportJobCommandOutput | GetImportJobCommandOutput | GetMessageInsightsCommandOutput | GetMultiRegionEndpointCommandOutput | GetReputationEntityCommandOutput | GetSuppressedDestinationCommandOutput | GetTenantCommandOutput | ListConfigurationSetsCommandOutput | ListContactListsCommandOutput | ListContactsCommandOutput | ListCustomVerificationEmailTemplatesCommandOutput | ListDedicatedIpPoolsCommandOutput | ListDeliverabilityTestReportsCommandOutput | ListDomainDeliverabilityCampaignsCommandOutput | ListEmailIdentitiesCommandOutput | ListEmailTemplatesCommandOutput | ListExportJobsCommandOutput | ListImportJobsCommandOutput | ListMultiRegionEndpointsCommandOutput | ListRecommendationsCommandOutput | ListReputationEntitiesCommandOutput | ListResourceTenantsCommandOutput | ListSuppressedDestinationsCommandOutput | ListTagsForResourceCommandOutput | ListTenantResourcesCommandOutput | ListTenantsCommandOutput | PutAccountDedicatedIpWarmupAttributesCommandOutput | PutAccountDetailsCommandOutput | PutAccountSendingAttributesCommandOutput | PutAccountSuppressionAttributesCommandOutput | PutAccountVdmAttributesCommandOutput | PutConfigurationSetArchivingOptionsCommandOutput | PutConfigurationSetDeliveryOptionsCommandOutput | PutConfigurationSetReputationOptionsCommandOutput | PutConfigurationSetSendingOptionsCommandOutput | PutConfigurationSetSuppressionOptionsCommandOutput | PutConfigurationSetTrackingOptionsCommandOutput | PutConfigurationSetVdmOptionsCommandOutput | PutDedicatedIpInPoolCommandOutput | PutDedicatedIpPoolScalingAttributesCommandOutput | PutDedicatedIpWarmupAttributesCommandOutput | PutDeliverabilityDashboardOptionCommandOutput | PutEmailIdentityConfigurationSetAttributesCommandOutput | PutEmailIdentityDkimAttributesCommandOutput | PutEmailIdentityDkimSigningAttributesCommandOutput | PutEmailIdentityFeedbackAttributesCommandOutput | PutEmailIdentityMailFromAttributesCommandOutput | PutSuppressedDestinationCommandOutput | SendBulkEmailCommandOutput | SendCustomVerificationEmailCommandOutput | SendEmailCommandOutput | TagResourceCommandOutput | TestRenderEmailTemplateCommandOutput | UntagResourceCommandOutput | UpdateConfigurationSetEventDestinationCommandOutput | UpdateContactCommandOutput | UpdateContactListCommandOutput | UpdateCustomVerificationEmailTemplateCommandOutput | UpdateEmailIdentityPolicyCommandOutput | UpdateEmailTemplateCommandOutput | UpdateReputationEntityCustomerManagedStatusCommandOutput | UpdateReputationEntityPolicyCommandOutput;
/**
 * @public
 */
export interface ClientDefaults extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
    /**
     * The HTTP handler to use or its constructor options. Fetch in browser and Https in Nodejs.
     */
    requestHandler?: __HttpHandlerUserInput;
    /**
     * A constructor for a class implementing the {@link @smithy/types#ChecksumConstructor} interface
     * that computes the SHA-256 HMAC or checksum of a string or binary buffer.
     * @internal
     */
    sha256?: __ChecksumConstructor | __HashConstructor;
    /**
     * The function that will be used to convert strings into HTTP endpoints.
     * @internal
     */
    urlParser?: __UrlParser;
    /**
     * A function that can calculate the length of a request body.
     * @internal
     */
    bodyLengthChecker?: __BodyLengthCalculator;
    /**
     * A function that converts a stream into an array of bytes.
     * @internal
     */
    streamCollector?: __StreamCollector;
    /**
     * The function that will be used to convert a base64-encoded string to a byte array.
     * @internal
     */
    base64Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a base64-encoded string.
     * @internal
     */
    base64Encoder?: __Encoder;
    /**
     * The function that will be used to convert a UTF8-encoded string to a byte array.
     * @internal
     */
    utf8Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a UTF-8 encoded string.
     * @internal
     */
    utf8Encoder?: __Encoder;
    /**
     * The runtime environment.
     * @internal
     */
    runtime?: string;
    /**
     * Disable dynamically changing the endpoint of the client based on the hostPrefix
     * trait of an operation.
     */
    disableHostPrefix?: boolean;
    /**
     * Unique service identifier.
     * @internal
     */
    serviceId?: string;
    /**
     * Enables IPv6/IPv4 dualstack endpoint.
     */
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    /**
     * Enables FIPS compatible endpoints.
     */
    useFipsEndpoint?: boolean | __Provider<boolean>;
    /**
     * The AWS region to which this client will send requests
     */
    region?: string | __Provider<string>;
    /**
     * Setting a client profile is similar to setting a value for the
     * AWS_PROFILE environment variable. Setting a profile on a client
     * in code only affects the single client instance, unlike AWS_PROFILE.
     *
     * When set, and only for environments where an AWS configuration
     * file exists, fields configurable by this file will be retrieved
     * from the specified profile within that file.
     * Conflicting code configuration and environment variables will
     * still have higher priority.
     *
     * For client credential resolution that involves checking the AWS
     * configuration file, the client's profile (this value) will be
     * used unless a different profile is set in the credential
     * provider options.
     *
     */
    profile?: string;
    /**
     * The provider populating default tracking information to be sent with `user-agent`, `x-amz-user-agent` header
     * @internal
     */
    defaultUserAgentProvider?: Provider<__UserAgent>;
    /**
     * Default credentials provider; Not available in browser runtime.
     * @deprecated
     * @internal
     */
    credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
    /**
     * Value for how many times a request will be made at most in case of retry.
     */
    maxAttempts?: number | __Provider<number>;
    /**
     * Specifies which retry algorithm to use.
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/Package/-smithy-util-retry/Enum/RETRY_MODES/
     *
     */
    retryMode?: string | __Provider<string>;
    /**
     * Optional logger for logging debug/info/warn/error.
     */
    logger?: __Logger;
    /**
     * Optional extensions
     */
    extensions?: RuntimeExtension[];
    /**
     * The protocol controlling the message type (e.g. HTTP) and format (e.g. JSON)
     * may be overridden. A default will always be set by the client.
     * Available options depend on the service's supported protocols and will not be validated by
     * the client.
     * @alpha
     *
     */
    protocol?: ClientProtocol<HttpRequest, HttpResponse>;
    /**
     * The {@link @smithy/smithy-client#DefaultsMode} that will be used to determine how certain default configuration options are resolved in the SDK.
     */
    defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
/**
 * @public
 */
export type SESv2ClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & UserAgentInputConfig & RetryInputConfig & RegionInputConfig & HostHeaderInputConfig & EndpointInputConfig<EndpointParameters> & HttpAuthSchemeInputConfig & ClientInputEndpointParameters;
/**
 * @public
 *
 *  The configuration interface of SESv2Client class constructor that set the region, credentials and other options.
 */
export interface SESv2ClientConfig extends SESv2ClientConfigType {
}
/**
 * @public
 */
export type SESv2ClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RuntimeExtensionsConfig & UserAgentResolvedConfig & RetryResolvedConfig & RegionResolvedConfig & HostHeaderResolvedConfig & EndpointResolvedConfig<EndpointParameters> & HttpAuthSchemeResolvedConfig & ClientResolvedEndpointParameters;
/**
 * @public
 *
 *  The resolved configuration interface of SESv2Client class. This is resolved and normalized from the {@link SESv2ClientConfig | constructor configuration interface}.
 */
export interface SESv2ClientResolvedConfig extends SESv2ClientResolvedConfigType {
}
/**
 * <fullname>Amazon SES API v2</fullname>
 *          <p>
 *             <a href="http://aws.amazon.com/ses">Amazon SES</a> is an Amazon Web Services service that
 *             you can use to send email messages to your customers.</p>
 *          <p>If you're new to Amazon SES API v2, you might find it helpful to review the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/">Amazon Simple Email Service Developer
 *                 Guide</a>. The <i>Amazon SES Developer Guide</i> provides information
 *             and code samples that demonstrate how to use Amazon SES API v2 features programmatically.</p>
 * @public
 */
export declare class SESv2Client extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, SESv2ClientResolvedConfig> {
    /**
     * The resolved configuration of SESv2Client class. This is resolved and normalized from the {@link SESv2ClientConfig | constructor configuration interface}.
     */
    readonly config: SESv2ClientResolvedConfig;
    constructor(...[configuration]: __CheckOptionalClientConfig<SESv2ClientConfig>);
    /**
     * Destroy underlying resources, like sockets. It's usually not necessary to do this.
     * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
     * Otherwise, sockets might stay open for quite a long time before the server terminates them.
     */
    destroy(): void;
}
