// File generated from our OpenAPI spec

declare module 'stripe' {
  namespace Stripe {
    namespace Terminal {
      interface ReaderCreateParams {
        /**
         * A code generated by the reader used for registering to an account.
         */
        registration_code: string;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * Custom label given to the reader for easier identification. If no label is specified, the registration code will be used.
         */
        label?: string;

        /**
         * The location to assign the reader to.
         */
        location?: string;

        /**
         * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
         */
        metadata?: Stripe.Emptyable<Stripe.MetadataParam>;
      }

      interface ReaderRetrieveParams {
        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;
      }

      interface ReaderUpdateParams {
        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * The new label of the reader.
         */
        label?: Stripe.Emptyable<string>;

        /**
         * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
         */
        metadata?: Stripe.Emptyable<Stripe.MetadataParam>;
      }

      interface ReaderListParams extends PaginationParams {
        /**
         * Filters readers by device type
         */
        device_type?: ReaderListParams.DeviceType;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * A location ID to filter the response list to only readers at the specific location
         */
        location?: string;

        /**
         * Filters readers by serial number
         */
        serial_number?: string;

        /**
         * A status filter to filter readers to only offline or online readers
         */
        status?: ReaderListParams.Status;
      }

      namespace ReaderListParams {
        type DeviceType =
          | 'bbpos_chipper2x'
          | 'bbpos_wisepad3'
          | 'bbpos_wisepos_e'
          | 'mobile_phone_reader'
          | 'simulated_stripe_s700'
          | 'simulated_wisepos_e'
          | 'stripe_m2'
          | 'stripe_s700'
          | 'verifone_P400';

        type Status = 'offline' | 'online';
      }

      interface ReaderDeleteParams {}

      interface ReaderCancelActionParams {
        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;
      }

      interface ReaderCollectInputsParams {
        /**
         * List of inputs to be collected from the customer using the Reader. Maximum 5 inputs.
         */
        inputs: Array<ReaderCollectInputsParams.Input>;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
         */
        metadata?: Stripe.MetadataParam;
      }

      namespace ReaderCollectInputsParams {
        interface Input {
          /**
           * Customize the text which will be displayed while collecting this input
           */
          custom_text: Input.CustomText;

          /**
           * Indicate that this input is required, disabling the skip button
           */
          required?: boolean;

          /**
           * Options for the `selection` input
           */
          selection?: Input.Selection;

          /**
           * List of toggles to be displayed and customization for the toggles
           */
          toggles?: Array<Input.Toggle>;

          /**
           * The type of input to collect
           */
          type: Input.Type;
        }

        namespace Input {
          interface CustomText {
            /**
             * The description which will be displayed when collecting this input
             */
            description?: string;

            /**
             * Custom text for the skip button. Maximum 14 characters.
             */
            skip_button?: string;

            /**
             * Custom text for the submit button. Maximum 30 characters.
             */
            submit_button?: string;

            /**
             * The title which will be displayed when collecting this input
             */
            title: string;
          }

          interface Selection {
            /**
             * List of choices for the `selection` input
             */
            choices: Array<Selection.Choice>;
          }

          namespace Selection {
            interface Choice {
              /**
               * The unique identifier for this choice
               */
              id: string;

              /**
               * The style of the button which will be shown for this choice. Can be `primary` or `secondary`.
               */
              style?: Choice.Style;

              /**
               * The text which will be shown on the button for this choice
               */
              text: string;
            }

            namespace Choice {
              type Style = 'primary' | 'secondary';
            }
          }

          interface Toggle {
            /**
             * The default value of the toggle. Can be `enabled` or `disabled`.
             */
            default_value?: Toggle.DefaultValue;

            /**
             * The description which will be displayed for the toggle. Maximum 50 characters. At least one of title or description must be provided.
             */
            description?: string;

            /**
             * The title which will be displayed for the toggle. Maximum 50 characters. At least one of title or description must be provided.
             */
            title?: string;
          }

          namespace Toggle {
            type DefaultValue = 'disabled' | 'enabled';
          }

          type Type =
            | 'email'
            | 'numeric'
            | 'phone'
            | 'selection'
            | 'signature'
            | 'text';
        }
      }

      interface ReaderCollectPaymentMethodParams {
        /**
         * The ID of the PaymentIntent to collect a payment method for.
         */
        payment_intent: string;

        /**
         * Configuration overrides for this collection, such as tipping, surcharging, and customer cancellation settings.
         */
        collect_config?: ReaderCollectPaymentMethodParams.CollectConfig;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;
      }

      namespace ReaderCollectPaymentMethodParams {
        interface CollectConfig {
          /**
           * This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow.
           */
          allow_redisplay?: CollectConfig.AllowRedisplay;

          /**
           * Enables cancel button on transaction screens.
           */
          enable_customer_cancellation?: boolean;

          /**
           * Override showing a tipping selection screen on this transaction.
           */
          skip_tipping?: boolean;

          /**
           * Tipping configuration for this transaction.
           */
          tipping?: CollectConfig.Tipping;
        }

        namespace CollectConfig {
          type AllowRedisplay = 'always' | 'limited' | 'unspecified';

          interface Tipping {
            /**
             * Amount used to calculate tip suggestions on tipping selection screen for this transaction. Must be a positive integer in the smallest currency unit (e.g., 100 cents to represent $1.00 or 100 to represent ¥100, a zero-decimal currency).
             */
            amount_eligible?: number;
          }
        }
      }

      interface ReaderConfirmPaymentIntentParams {
        /**
         * The ID of the PaymentIntent to confirm.
         */
        payment_intent: string;

        /**
         * Configuration overrides for this confirmation, such as surcharge settings and return URL.
         */
        confirm_config?: ReaderConfirmPaymentIntentParams.ConfirmConfig;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;
      }

      namespace ReaderConfirmPaymentIntentParams {
        interface ConfirmConfig {
          /**
           * The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site. If you'd prefer to redirect to a mobile application, you can alternatively supply an application URI scheme.
           */
          return_url?: string;
        }
      }

      interface ReaderProcessPaymentIntentParams {
        /**
         * The ID of the PaymentIntent to process on the reader.
         */
        payment_intent: string;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * Configuration overrides for this transaction, such as tipping and customer cancellation settings.
         */
        process_config?: ReaderProcessPaymentIntentParams.ProcessConfig;
      }

      namespace ReaderProcessPaymentIntentParams {
        interface ProcessConfig {
          /**
           * This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow.
           */
          allow_redisplay?: ProcessConfig.AllowRedisplay;

          /**
           * Enables cancel button on transaction screens.
           */
          enable_customer_cancellation?: boolean;

          /**
           * The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site. If you'd prefer to redirect to a mobile application, you can alternatively supply an application URI scheme.
           */
          return_url?: string;

          /**
           * Override showing a tipping selection screen on this transaction.
           */
          skip_tipping?: boolean;

          /**
           * Tipping configuration for this transaction.
           */
          tipping?: ProcessConfig.Tipping;
        }

        namespace ProcessConfig {
          type AllowRedisplay = 'always' | 'limited' | 'unspecified';

          interface Tipping {
            /**
             * Amount used to calculate tip suggestions on tipping selection screen for this transaction. Must be a positive integer in the smallest currency unit (e.g., 100 cents to represent $1.00 or 100 to represent ¥100, a zero-decimal currency).
             */
            amount_eligible?: number;
          }
        }
      }

      interface ReaderProcessSetupIntentParams {
        /**
         * This field indicates whether this payment method can be shown again to its customer in a checkout flow. Stripe products such as Checkout and Elements use this field to determine whether a payment method can be shown as a saved payment method in a checkout flow.
         */
        allow_redisplay: ReaderProcessSetupIntentParams.AllowRedisplay;

        /**
         * The ID of the SetupIntent to process on the reader.
         */
        setup_intent: string;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * Configuration overrides for this setup, such as MOTO and customer cancellation settings.
         */
        process_config?: ReaderProcessSetupIntentParams.ProcessConfig;
      }

      namespace ReaderProcessSetupIntentParams {
        type AllowRedisplay = 'always' | 'limited' | 'unspecified';

        interface ProcessConfig {
          /**
           * Enables cancel button on transaction screens.
           */
          enable_customer_cancellation?: boolean;
        }
      }

      interface ReaderRefundPaymentParams {
        /**
         * A positive integer in __cents__ representing how much of this charge to refund.
         */
        amount?: number;

        /**
         * ID of the Charge to refund.
         */
        charge?: string;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;

        /**
         * Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
         */
        metadata?: Stripe.MetadataParam;

        /**
         * ID of the PaymentIntent to refund.
         */
        payment_intent?: string;

        /**
         * Boolean indicating whether the application fee should be refunded when refunding this charge. If a full charge refund is given, the full application fee will be refunded. Otherwise, the application fee will be refunded in an amount proportional to the amount of the charge refunded. An application fee can be refunded only by the application that created the charge.
         */
        refund_application_fee?: boolean;

        /**
         * Configuration overrides for this refund, such as customer cancellation settings.
         */
        refund_payment_config?: ReaderRefundPaymentParams.RefundPaymentConfig;

        /**
         * Boolean indicating whether the transfer should be reversed when refunding this charge. The transfer will be reversed proportionally to the amount being refunded (either the entire or partial amount). A transfer can be reversed only by the application that created the charge.
         */
        reverse_transfer?: boolean;
      }

      namespace ReaderRefundPaymentParams {
        interface RefundPaymentConfig {
          /**
           * Enables cancel button on transaction screens.
           */
          enable_customer_cancellation?: boolean;
        }
      }

      interface ReaderSetReaderDisplayParams {
        /**
         * Type of information to display. Only `cart` is currently supported.
         */
        type: 'cart';

        /**
         * Cart details to display on the reader screen, including line items, amounts, and currency.
         */
        cart?: ReaderSetReaderDisplayParams.Cart;

        /**
         * Specifies which fields in the response should be expanded.
         */
        expand?: Array<string>;
      }

      namespace ReaderSetReaderDisplayParams {
        interface Cart {
          /**
           * Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
           */
          currency: string;

          /**
           * Array of line items to display.
           */
          line_items: Array<Cart.LineItem>;

          /**
           * The amount of tax in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
           */
          tax?: number;

          /**
           * Total balance of cart due in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
           */
          total: number;
        }

        namespace Cart {
          interface LineItem {
            /**
             * The price of the item in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal).
             */
            amount: number;

            /**
             * The description or name of the item.
             */
            description: string;

            /**
             * The quantity of the line item being purchased.
             */
            quantity: number;
          }
        }
      }

      class ReadersResource {
        /**
         * Creates a new Reader object.
         */
        create(
          params: ReaderCreateParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Retrieves a Reader object.
         */
        retrieve(
          id: string,
          params?: ReaderRetrieveParams,
          options?: RequestOptions
        ): Promise<
          Stripe.Response<
            Stripe.Terminal.Reader | Stripe.Terminal.DeletedReader
          >
        >;
        retrieve(
          id: string,
          options?: RequestOptions
        ): Promise<
          Stripe.Response<
            Stripe.Terminal.Reader | Stripe.Terminal.DeletedReader
          >
        >;

        /**
         * Updates a Reader object by setting the values of the parameters passed. Any parameters not provided will be left unchanged.
         */
        update(
          id: string,
          params?: ReaderUpdateParams,
          options?: RequestOptions
        ): Promise<
          Stripe.Response<
            Stripe.Terminal.Reader | Stripe.Terminal.DeletedReader
          >
        >;

        /**
         * Returns a list of Reader objects.
         */
        list(
          params?: ReaderListParams,
          options?: RequestOptions
        ): ApiListPromise<Stripe.Terminal.Reader>;
        list(options?: RequestOptions): ApiListPromise<Stripe.Terminal.Reader>;

        /**
         * Deletes a Reader object.
         */
        del(
          id: string,
          params?: ReaderDeleteParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.DeletedReader>>;
        del(
          id: string,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.DeletedReader>>;

        /**
         * Cancels the current reader action. See [Programmatic Cancellation](https://docs.stripe.com/docs/terminal/payments/collect-card-payment?terminal-sdk-platform=server-driven#programmatic-cancellation) for more details.
         */
        cancelAction(
          id: string,
          params?: ReaderCancelActionParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;
        cancelAction(
          id: string,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Initiates an [input collection flow](https://docs.stripe.com/docs/terminal/features/collect-inputs) on a Reader to display input forms and collect information from your customers.
         */
        collectInputs(
          id: string,
          params: ReaderCollectInputsParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Initiates a payment flow on a Reader and updates the PaymentIntent with card details before manual confirmation. See [Collecting a Payment method](https://docs.stripe.com/docs/terminal/payments/collect-card-payment?terminal-sdk-platform=server-driven&process=inspect#collect-a-paymentmethod) for more details.
         */
        collectPaymentMethod(
          id: string,
          params: ReaderCollectPaymentMethodParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Finalizes a payment on a Reader. See [Confirming a Payment](https://docs.stripe.com/docs/terminal/payments/collect-card-payment?terminal-sdk-platform=server-driven&process=inspect#confirm-the-paymentintent) for more details.
         */
        confirmPaymentIntent(
          id: string,
          params: ReaderConfirmPaymentIntentParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Initiates a payment flow on a Reader. See [process the payment](https://docs.stripe.com/docs/terminal/payments/collect-card-payment?terminal-sdk-platform=server-driven&process=immediately#process-payment) for more details.
         */
        processPaymentIntent(
          id: string,
          params: ReaderProcessPaymentIntentParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Initiates a SetupIntent flow on a Reader. See [Save directly without charging](https://docs.stripe.com/docs/terminal/features/saving-payment-details/save-directly) for more details.
         */
        processSetupIntent(
          id: string,
          params: ReaderProcessSetupIntentParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Initiates an in-person refund on a Reader. See [Refund an Interac Payment](https://docs.stripe.com/docs/terminal/payments/regional?integration-country=CA#refund-an-interac-payment) for more details.
         */
        refundPayment(
          id: string,
          params?: ReaderRefundPaymentParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;
        refundPayment(
          id: string,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;

        /**
         * Sets the reader display to show [cart details](https://docs.stripe.com/docs/terminal/features/display).
         */
        setReaderDisplay(
          id: string,
          params: ReaderSetReaderDisplayParams,
          options?: RequestOptions
        ): Promise<Stripe.Response<Stripe.Terminal.Reader>>;
      }
    }
  }
}
