import { PrismaClient } from '@prisma/client'

const prisma = new PrismaClient()

async function checkDatabase() {
  console.log('🔍 Verifying Database Connection...\n')
  console.log('=' .repeat(50))
  
  try {
    // Check Users
    const users = await prisma.user.findMany()
    console.log('👤 Users:', users.length)
    users.forEach(u => console.log('   -', u.email, `(${u.role})`))
    
    // Check Services
    const services = await prisma.service.count()
    console.log('\n📦 Services:', services)
    
    // Check Orders
    const orders = await prisma.order.count()
    console.log('🛒 Orders:', orders)
    
    // Check CMS Content
    const content = await prisma.content.count()
    console.log('📄 CMS Content:', content)
    
    // Check Homepage Sections
    const homepage = await prisma.homePageSection.count()
    console.log('🏠 Homepage Sections:', homepage)
    
    // Check Invoices
    const invoices = await prisma.invoice.count()
    console.log('💰 Invoices:', invoices)

    // Check Tickets
    const tickets = await prisma.ticket.count()
    console.log('🎫 Tickets:', tickets)

    // Check Clients
    const clients = await prisma.client.count()
    console.log('👥 Clients:', clients)
    
    console.log('\n' + '=' .repeat(50))
    console.log('✅ Database connection verified successfully!')
    console.log('=' .repeat(50))
    
  } catch (error: any) {
    console.error('❌ Database Error:', error.message)
  } finally {
    await prisma.$disconnect()
  }
}

checkDatabase()
