import { PrismaClient, UserRole } from '@prisma/client'
import bcrypt from 'bcryptjs'

const prisma = new PrismaClient()

async function createAdminUser() {
  try {
    console.log('🔧 Setting up admin user...')
    
    // Check if admin user already exists
    const existingAdmin = await prisma.user.findUnique({
      where: { email: 'sales@nuwair.com' }
    })

    if (existingAdmin) {
      console.log('✓ Admin user already exists')
      console.log('📧 Email: sales@nuwair.com')
      console.log('🔑 Password: admin123')
      console.log('👤 Role: ADMIN')
      return
    }

    // Hash the password
    const hashedPassword = await bcrypt.hash('admin123', 12)

    // Create admin user
    const adminUser = await prisma.user.create({
      data: {
        email: 'sales@nuwair.com',
        name: 'Admin User',
        password: hashedPassword,
        role: UserRole.ADMIN,
        emailVerified: new Date(),
      }
    })

    console.log('🎉 Admin user created successfully!')
    console.log('📧 Email: sales@nuwair.com')
    console.log('🔑 Password: admin123')
    console.log('👤 Role: ADMIN')
    console.log('')
    console.log('🌐 You can now login at: http://localhost:3000/auth/signin')
    console.log('🛡️  Admin dashboard: http://localhost:3000/admin')

  } catch (error) {
    console.error('❌ Error creating admin user:', error)
  } finally {
    await prisma.$disconnect()
  }
}

createAdminUser()