import { PrismaClient } from '@prisma/client'
import bcrypt from 'bcryptjs'

const prisma = new PrismaClient()

async function resetAdminPassword() {
  try {
    console.log('🔧 Forcibly resetting admin password...')
    const email = 'sales@nuwair.com'
    const newPassword = 'Admin@2025!'
    const hashedPassword = await bcrypt.hash(newPassword, 12)
    const user = await prisma.user.findUnique({ where: { email } })
    if (!user) {
      await prisma.user.create({
        data: {
          email,
          name: 'Admin User',
          password: hashedPassword,
          role: 'ADMIN',
          emailVerified: new Date(),
        }
      })
      console.log('🎉 Admin user created!')
    } else {
      await prisma.user.update({
        where: { email },
        data: {
          password: hashedPassword,
          emailVerified: new Date(),
        }
      })
      console.log('✅ Admin password reset!')
    }
    console.log('📧 Email:', email)
    console.log('🔑 Password:', newPassword)
    console.log('👤 Role: ADMIN')
    console.log('🌐 Login at: http://localhost:3000/auth/signin')
  } catch (error) {
    console.error('❌ Error:', error)
  } finally {
    await prisma.$disconnect()
  }
}

resetAdminPassword()
