import { PrismaClient, UserRole } from '@prisma/client'
import bcrypt from 'bcryptjs'

const prisma = new PrismaClient()

async function resetAdminPassword() {
  try {
    console.log('🔧 Resetting admin password...')
    
    // Find admin user
    const adminUser = await prisma.user.findUnique({
      where: { email: 'sales@nuwair.com' }
    })

    if (!adminUser) {
      console.log('❌ Admin user not found. Creating new admin user...')
      
      // Hash the password
      const hashedPassword = await bcrypt.hash('admin123', 12)

      // Create admin user
      await prisma.user.create({
        data: {
          email: 'sales@nuwair.com',
          name: 'Admin User',
          password: hashedPassword,
          role: UserRole.ADMIN,
          emailVerified: new Date(),
        }
      })

      console.log('🎉 Admin user created successfully!')
    } else {
      // Hash the new password
      const hashedPassword = await bcrypt.hash('admin123', 12)

      // Update admin password
      await prisma.user.update({
        where: { email: 'sales@nuwair.com' },
        data: {
          password: hashedPassword,
          emailVerified: new Date(),
        }
      })

      console.log('🎉 Admin password reset successfully!')
    }

    console.log('')
    console.log('✅ Admin Credentials:')
    console.log('📧 Email: sales@nuwair.com')
    console.log('🔑 Password: admin123')
    console.log('👤 Role: ADMIN')
    console.log('')
    console.log('🌐 Login at: http://localhost:3000/auth/signin')
    console.log('🛡️  Admin dashboard: http://localhost:3000/admin/dashboard')
    console.log('')
    console.log('💡 Tip: Make sure the dev server is running with: npm run dev')

  } catch (error) {
    console.error('❌ Error resetting admin password:', error)
  } finally {
    await prisma.$disconnect()
  }
}

resetAdminPassword()
