import { PrismaClient } from '@prisma/client'

const prisma = new PrismaClient()

async function seedHomepageContent() {
  const content = [
    // Hero Section
    { section: 'hero', key: 'badge_text', value: 'Trusted by 500+ Businesses', type: 'text', order: 1 },
    { section: 'hero', key: 'title_line1', value: 'Transform Your', type: 'text', order: 2 },
    { section: 'hero', key: 'title_line2', value: 'Digital Vision', type: 'text', order: 3 },
    { section: 'hero', key: 'subtitle', value: 'Award-winning IT solutions that drive growth. From AI-powered apps to stunning web experiences.', type: 'textarea', order: 4 },
    { section: 'hero', key: 'cta1_text', value: 'Start Your Project', type: 'text', order: 5 },
    { section: 'hero', key: 'cta1_link', value: '/contact', type: 'url', order: 6 },
    { section: 'hero', key: 'cta2_text', value: 'View Portfolio', type: 'text', order: 7 },
    { section: 'hero', key: 'cta2_link', value: '/portfolio', type: 'url', order: 8 },
    
    // Stats Section
    { section: 'stats', key: 'title', value: 'Check Domain Availability', type: 'text', order: 1 },
    { section: 'stats', key: 'subtitle', value: 'Find your perfect domain name and secure your online presence', type: 'textarea', order: 2 },
    { section: 'stats', key: 'stat1_value', value: '500+', type: 'text', order: 3 },
    { section: 'stats', key: 'stat1_label', value: 'Happy Clients', type: 'text', order: 4 },
    { section: 'stats', key: 'stat2_value', value: '1000+', type: 'text', order: 5 },
    { section: 'stats', key: 'stat2_label', value: 'Projects Done', type: 'text', order: 6 },
    { section: 'stats', key: 'stat3_value', value: '24/7', type: 'text', order: 7 },
    { section: 'stats', key: 'stat3_label', value: 'Support', type: 'text', order: 8 },
    { section: 'stats', key: 'stat4_value', value: '99.9%', type: 'text', order: 9 },
    { section: 'stats', key: 'stat4_label', value: 'Uptime', type: 'text', order: 10 },
    
    // Services Section
    { section: 'services', key: 'title', value: 'Our Services', type: 'text', order: 1 },
    { section: 'services', key: 'subtitle', value: 'Comprehensive IT solutions tailored to your needs', type: 'textarea', order: 2 },
    
    // Why Choose Us Section
    { section: 'whychooseus', key: 'title', value: 'Why Choose Nuwair Systems', type: 'text', order: 1 },
    { section: 'whychooseus', key: 'subtitle', value: 'Experience excellence in every project we deliver', type: 'textarea', order: 2 },
    { section: 'whychooseus', key: 'feature1_title', value: 'Expert Team', type: 'text', order: 3 },
    { section: 'whychooseus', key: 'feature1_desc', value: 'Certified professionals with years of experience', type: 'textarea', order: 4 },
    { section: 'whychooseus', key: 'feature2_title', value: 'Quality Assurance', type: 'text', order: 5 },
    { section: 'whychooseus', key: 'feature2_desc', value: 'Rigorous testing ensures flawless delivery', type: 'textarea', order: 6 },
    { section: 'whychooseus', key: 'feature3_title', value: 'On-Time Delivery', type: 'text', order: 7 },
    { section: 'whychooseus', key: 'feature3_desc', value: 'We respect deadlines and deliver on schedule', type: 'textarea', order: 8 },
    { section: 'whychooseus', key: 'feature4_title', value: '24/7 Support', type: 'text', order: 9 },
    { section: 'whychooseus', key: 'feature4_desc', value: 'Round-the-clock assistance when you need it', type: 'textarea', order: 10 },
    
    // Contact Section
    { section: 'contact', key: 'title', value: 'Get In Touch', type: 'text', order: 1 },
    { section: 'contact', key: 'subtitle', value: 'Have a project in mind? Let\'s discuss how we can help', type: 'textarea', order: 2 },
    { section: 'contact', key: 'address', value: '123 Business Street, Tech City', type: 'text', order: 3 },
    { section: 'contact', key: 'phone', value: '+1 (555) 123-4567', type: 'text', order: 4 },
    { section: 'contact', key: 'email', value: 'info@nuwairsystems.com', type: 'text', order: 5 },
    { section: 'contact', key: 'hours', value: 'Mon - Fri: 9:00 AM - 6:00 PM', type: 'text', order: 6 },
  ]

  console.log('Seeding homepage content...')
  
  for (const item of content) {
    await prisma.homePageSection.upsert({
      where: {
        section_key: {
          section: item.section,
          key: item.key
        }
      },
      update: {},
      create: item
    })
  }

  console.log('Homepage content seeded successfully!')
}

async function main() {
  try {
    await seedHomepageContent()
  } catch (error) {
    console.error('Error seeding data:', error)
    throw error
  }
}

main()
  .catch((e) => {
    console.error(e)
    process.exit(1)
  })
  .finally(async () => {
    await prisma.$disconnect()
  })
