'use client'

import { motion } from 'framer-motion'
import { 
  CheckCircleIcon, 
  LightBulbIcon, 
  ShieldCheckIcon, 
  RocketLaunchIcon,
  UserGroupIcon,
  GlobeAltIcon,
  HeartIcon
} from '@heroicons/react/24/outline'

const stats = [
  { label: 'Years of Experience', value: '8+' },
  { label: 'Happy Clients', value: '500+' },
  { label: 'Projects Completed', value: '1000+' },
  { label: 'Team Members', value: '15+' },
]

const values = [
  {
    icon: LightBulbIcon,
    title: 'Innovation',
    description: 'We stay ahead of technology trends and implement cutting-edge solutions that give our clients a competitive advantage.'
  },
  {
    icon: ShieldCheckIcon,
    title: 'Reliability',
    description: 'Our clients trust us to deliver consistent, high-quality results on time and within budget, every single time.'
  },
  {
    icon: HeartIcon,
    title: 'Customer-Centric',
    description: 'We put our clients first, understanding their unique needs and tailoring solutions that exceed expectations.'
  },
  {
    icon: GlobeAltIcon,
    title: 'Global Reach',
    description: 'Serving clients worldwide with 24/7 support and understanding of diverse markets and business cultures.'
  }
]

const team = [
  {
    name: 'Ahmed Nuwair',
    role: 'CEO & Founder',
    image: '/team/ceo.jpg',
    description: 'Visionary leader with 10+ years experience in IT solutions and digital transformation.'
  },
  {
    name: 'Sarah Johnson',
    role: 'CTO',
    image: '/team/cto.jpg',
    description: 'Tech expert specializing in cloud architecture and enterprise software development.'
  },
  {
    name: 'Michael Chen',
    role: 'Head of Marketing',
    image: '/team/marketing.jpg',
    description: 'Digital marketing strategist with proven track record in growth and ROI optimization.'
  },
  {
    name: 'Emily Rodriguez',
    role: 'Lead Developer',
    image: '/team/developer.jpg',
    description: 'Full-stack developer passionate about creating scalable and user-friendly applications.'
  }
]

const milestones = [
  {
    year: '2016',
    title: 'Company Founded',
    description: 'Started as a small IT consulting firm with a vision to democratize technology for businesses.'
  },
  {
    year: '2018',
    title: 'First 100 Clients',
    description: 'Reached our first major milestone by serving over 100 satisfied clients across various industries.'
  },
  {
    year: '2020',
    title: 'Digital Transformation',
    description: 'Expanded services to include comprehensive digital transformation and cloud migration solutions.'
  },
  {
    year: '2022',
    title: 'Global Expansion',
    description: 'Opened international offices and started serving clients across multiple continents.'
  },
  {
    year: '2024',
    title: 'AI Integration',
    description: 'Incorporated AI and machine learning solutions into our service portfolio.'
  }
]

export default function About() {
  return (
    <div className="bg-white">
      {/* Hero Section */}
      <div className="relative bg-gradient-to-r from-blue-600 to-purple-600 py-24">
        <div className="absolute inset-0 bg-black opacity-10"></div>
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
          >
            <h1 className="text-4xl md:text-6xl font-bold text-white mb-6">
              About <span className="text-yellow-300">Nuwair Systems</span>
            </h1>
            <p className="text-xl text-blue-100 max-w-3xl mx-auto">
              Empowering businesses with innovative IT solutions since 2016. We're passionate about 
              transforming ideas into digital reality and helping companies thrive in the modern world.
            </p>
          </motion.div>
        </div>
      </div>

      {/* Stats Section */}
      <div className="py-16 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-2 gap-8 md:grid-cols-4">
            {stats.map((stat, index) => (
              <motion.div
                key={stat.label}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.6, delay: index * 0.1 }}
                className="text-center"
              >
                <div className="text-4xl font-bold text-blue-600 mb-2">{stat.value}</div>
                <div className="text-gray-600">{stat.label}</div>
              </motion.div>
            ))}
          </div>
        </div>
      </div>

      {/* Our Story */}
      <div className="py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="lg:grid lg:grid-cols-2 lg:gap-16 lg:items-center">
            <motion.div
              initial={{ opacity: 0, x: -20 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.6 }}
            >
              <h2 className="text-3xl font-bold text-gray-900 mb-6">Our Story</h2>
              <p className="text-lg text-gray-600 mb-6">
                Founded in 2016 by Ahmed Nuwair, Nuwair Systems began as a vision to bridge the gap 
                between complex technology and practical business solutions. What started as a small 
                consultancy has grown into a full-service IT company serving clients worldwide.
              </p>
              <p className="text-lg text-gray-600 mb-6">
                Our journey has been marked by continuous innovation, unwavering commitment to quality, 
                and a deep understanding that technology should serve people, not the other way around. 
                Today, we're proud to be trusted partners to over 500 businesses across various industries.
              </p>
              <p className="text-lg text-gray-600">
                From domain registration to complex enterprise solutions, we've maintained our core 
                principle: deliver exceptional value through innovative technology solutions that 
                drive real business results.
              </p>
            </motion.div>

            <motion.div
              initial={{ opacity: 0, x: 20 }}
              whileInView={{ opacity: 1, x: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.6 }}
              className="mt-10 lg:mt-0"
            >
              <div className="bg-gradient-to-r from-blue-600 to-purple-600 rounded-2xl p-8 text-white">
                <h3 className="text-2xl font-bold mb-4">Our Mission</h3>
                <p className="text-blue-100 mb-6">
                  To empower businesses of all sizes with innovative, reliable, and scalable IT solutions 
                  that drive growth, efficiency, and success in the digital age.
                </p>
                <h3 className="text-2xl font-bold mb-4">Our Vision</h3>
                <p className="text-blue-100">
                  To be the most trusted technology partner, known for transforming business challenges 
                  into opportunities through cutting-edge solutions and exceptional service.
                </p>
              </div>
            </motion.div>
          </div>
        </div>
      </div>

      {/* Values */}
      <div className="py-20 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
            className="text-center mb-16"
          >
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Our Core Values</h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              These principles guide everything we do and shape the way we work with our clients and each other.
            </p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {values.map((value, index) => {
              const Icon = value.icon
              return (
                <motion.div
                  key={value.title}
                  initial={{ opacity: 0, y: 20 }}
                  whileInView={{ opacity: 1, y: 0 }}
                  viewport={{ once: true }}
                  transition={{ duration: 0.6, delay: index * 0.1 }}
                  className="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow"
                >
                  <div className="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-4">
                    <Icon className="w-6 h-6 text-blue-600" />
                  </div>
                  <h3 className="text-xl font-semibold text-gray-900 mb-2">{value.title}</h3>
                  <p className="text-gray-600">{value.description}</p>
                </motion.div>
              )
            })}
          </div>
        </div>
      </div>

      {/* Timeline */}
      <div className="py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
            className="text-center mb-16"
          >
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Our Journey</h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              Key milestones that have shaped Nuwair Systems into the company we are today.
            </p>
          </motion.div>

          <div className="relative">
            <div className="absolute left-1/2 transform -translate-x-px h-full w-0.5 bg-gray-200"></div>
            {milestones.map((milestone, index) => (
              <motion.div
                key={milestone.year}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.6, delay: index * 0.1 }}
                className={`relative flex items-center ${
                  index % 2 === 0 ? 'justify-start' : 'justify-end'
                } mb-12`}
              >
                <div className={`w-5/12 ${index % 2 === 0 ? 'pr-8 text-right' : 'pl-8 text-left'}`}>
                  <div className="bg-white rounded-lg p-6 shadow-md">
                    <div className="text-blue-600 font-bold text-lg mb-2">{milestone.year}</div>
                    <h3 className="text-xl font-semibold text-gray-900 mb-2">{milestone.title}</h3>
                    <p className="text-gray-600">{milestone.description}</p>
                  </div>
                </div>
                <div className="absolute left-1/2 transform -translate-x-1/2 w-4 h-4 bg-blue-600 rounded-full border-4 border-white"></div>
              </motion.div>
            ))}
          </div>
        </div>
      </div>

      {/* Team Section */}
      <div className="py-20 bg-gray-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
            className="text-center mb-16"
          >
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Meet Our Team</h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              The passionate professionals behind Nuwair Systems, dedicated to delivering excellence in every project.
            </p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {team.map((member, index) => (
              <motion.div
                key={member.name}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.6, delay: index * 0.1 }}
                className="bg-white rounded-xl p-6 shadow-sm hover:shadow-md transition-shadow text-center"
              >
                <div className="w-24 h-24 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full mx-auto mb-4 flex items-center justify-center">
                  <span className="text-white font-bold text-2xl">
                    {member.name.split(' ').map(n => n[0]).join('')}
                  </span>
                </div>
                <h3 className="text-xl font-semibold text-gray-900 mb-1">{member.name}</h3>
                <p className="text-blue-600 font-medium mb-3">{member.role}</p>
                <p className="text-gray-600 text-sm">{member.description}</p>
              </motion.div>
            ))}
          </div>
        </div>
      </div>

      {/* CTA Section */}
      <div className="py-20">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
          >
            <h2 className="text-3xl font-bold text-gray-900 mb-4">Ready to Get Started?</h2>
            <p className="text-xl text-gray-600 mb-8 max-w-3xl mx-auto">
              Join hundreds of satisfied clients who trust Nuwair Systems for their IT needs. 
              Let's discuss how we can help transform your business.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <motion.a
                href="/contact"
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
                className="bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-colors"
              >
                Contact Us Today
              </motion.a>
              <motion.a
                href="/services"
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
                className="border border-blue-600 text-blue-600 px-8 py-3 rounded-lg font-semibold hover:bg-blue-50 transition-colors"
              >
                View Our Services
              </motion.a>
            </div>
          </motion.div>
        </div>
      </div>
    </div>
  )
}