
"use client";
import React, { useEffect, useState } from 'react';

export default function AnalyticsDashboard() {
  const [data, setData] = useState({ totalUsers: 0, totalOrders: 0, totalRevenue: 0 });

  useEffect(() => {
    fetch('/api/admin/analytics')
      .then(res => res.json())
      .then(setData);
  }, []);

  return (
    <div className="p-8">
      <h1 className="text-2xl font-bold mb-4">Analytics Dashboard</h1>
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div className="card bg-base-100 shadow p-6">
          <h2 className="text-lg font-semibold">Total Users</h2>
          <p className="text-3xl">{data.totalUsers}</p>
        </div>
        <div className="card bg-base-100 shadow p-6">
          <h2 className="text-lg font-semibold">Total Orders</h2>
          <p className="text-3xl">{data.totalOrders}</p>
        </div>
        <div className="card bg-base-100 shadow p-6">
          <h2 className="text-lg font-semibold">Total Revenue</h2>
          <p className="text-3xl">${data.totalRevenue}</p>
        </div>
      </div>
    </div>
  );
}
