'use client'

import { useEffect } from 'react'
import { useRouter } from 'next/navigation'

export default function CMSRedirect() {
  const router = useRouter()

  useEffect(() => {
    // Redirect to main admin dashboard with CMS tab
    router.replace('/admin?tab=cms')
  }, [router])

  return (
    <div className="min-h-screen flex items-center justify-center bg-gray-50">
      <div className="text-center">
        <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600 mx-auto mb-4"></div>
        <p className="text-gray-600">Redirecting to Content Management...</p>
      </div>
    </div>
  )
}