"use client";

import React, { useEffect, useState } from 'react';

interface Notification {
  id: string;
  title: string;
  message: string;
  createdAt: string | number | Date;
}

export default function NotificationsPage() {
  const [notifications, setNotifications] = useState<Notification[]>([]);

  useEffect(() => {
    fetch('/api/admin/notifications')
      .then(res => res.json())
      .then(data => setNotifications(data));
  }, []);

  return (
    <div className="p-8">
      <h1 className="text-2xl font-bold mb-4">Notifications</h1>
      <ul className="list-disc pl-6">
        {notifications.map(n => (
          <li key={n.id} className="mb-2">
            <span className="font-semibold">{n.title}</span>: {n.message}
            <span className="ml-2 text-xs text-gray-500">{new Date(n.createdAt).toLocaleString()}</span>
          </li>
        ))}
      </ul>
    </div>
  );
}
