"use client";

import React, { useState } from 'react';
import Sidebar from '@/components/Sidebar'; // Import Sidebar component

export default function SettingsPage() {
  const [settings, setSettings] = useState({ siteName: '', supportEmail: '', theme: 'default' });

  // Example: handle settings update
  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLSelectElement>) => {
    setSettings({ ...settings, [e.target.name]: e.target.value });
  };

  const handleSave = async () => {
    try {
      const response = await fetch('/api/admin/settings', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(settings),
      });

      if (!response.ok) {
        throw new Error(`Failed to save settings: ${response.statusText}`);
      }

      const result = await response.json();
      alert('Settings saved successfully!');
    } catch (error) {
      console.error('Error saving settings:', error);
      alert('Failed to save settings. Please try again.');
    }
  };

  // Define tabs for the sidebar
  const tabs = ["General", "Appearance", "Security", "Notifications"];
  return (
    <div className="flex">
      <Sidebar tabs={tabs} activeTab={tabs[0]} /> {/* Sidebar for navigation */}
      <div className="p-8 flex-1">
        <h1 className="text-2xl font-bold mb-4">Settings</h1>
        <form className="space-y-4">
          <div>
            <label className="block font-semibold">Site Name</label>
            <input name="siteName" value={settings.siteName} onChange={handleChange} className="input input-bordered w-full" />
          </div>
          <div>
            <label className="block font-semibold">Support Email</label>
            <input name="supportEmail" value={settings.supportEmail} onChange={handleChange} className="input input-bordered w-full" />
          </div>
          <div>
            <label className="block font-semibold">Theme</label>
            <select name="theme" value={settings.theme} onChange={handleChange} className="select select-bordered w-full">
              <option value="default">Default</option>
              <option value="dark">Dark</option>
              <option value="light">Light</option>
            </select>
          </div>
          <button type="button" onClick={handleSave} className="btn btn-primary">Save Settings</button>
        </form>
      </div>
    </div>
  );
}
