
"use client";
import React, { useEffect, useState } from 'react';

type Ticket = {
  id: string;
  subject: string;
  status: string;
  userId: string;
  createdAt: string;
};

export default function SupportPage() {
  const [tickets, setTickets] = useState<Ticket[]>([]);

  useEffect(() => {
    fetch('/api/admin/support')
      .then(res => res.json())
      .then(setTickets);
  }, []);

  return (
    <div className="p-8">
      <h1 className="text-2xl font-bold mb-4">Support Tickets</h1>
      <table className="table-auto w-full">
        <thead>
          <tr>
            <th>ID</th>
            <th>Subject</th>
            <th>Status</th>
            <th>User</th>
            <th>Date</th>
          </tr>
        </thead>
        <tbody>
          {tickets.map(ticket => (
            <tr key={ticket.id}>
              <td>{ticket.id}</td>
              <td>{ticket.subject}</td>
              <td>{ticket.status}</td>
              <td>{ticket.userId}</td>
              <td>{new Date(ticket.createdAt).toLocaleString()}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
