import { Metadata } from 'next'
import { getServerSession } from 'next-auth'
import { redirect } from 'next/navigation'
import AIServiceRecommendations from '@/components/AIServiceRecommendations'

export const metadata: Metadata = {
  title: 'AI Service Recommendations | NuwairSystems',
  description: 'Get intelligent, personalized service recommendations based on your business type and goals using our AI-powered recommendation engine.',
}

export default async function AIRecommendationsPage() {
  const session = await getServerSession()

  if (!session) {
    redirect('/auth/signin?callbackUrl=/ai-recommendations')
  }

  return <AIServiceRecommendations />
}