import { NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

export async function GET() {
  // Example analytics: total users, total orders, total revenue
  const totalUsers = await prisma.user.count();
  const totalOrders = await prisma.order.count();
  const totalRevenue = await prisma.payment.aggregate({ _sum: { amount: true } });
  return NextResponse.json({
    totalUsers,
    totalOrders,
    totalRevenue: totalRevenue._sum.amount || 0
  });
}
