import { NextRequest, NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

// GET: List all services
export async function GET() {
  try {
    const services = await prisma.service.findMany();
    return NextResponse.json({ services });
  } catch (error) {
    return NextResponse.json({ error: 'Failed to fetch services.' }, { status: 500 });
  }
}

// POST: Create a new service
export async function POST(req: NextRequest) {
  try {
    const data = await req.json();
    const service = await prisma.service.create({ data });
    return NextResponse.json({ service });
  } catch (error) {
    return NextResponse.json({ error: 'Failed to create service.' }, { status: 500 });
  }
}
