import { NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

export async function GET() {
  const tickets = await prisma.ticket.findMany({ orderBy: { createdAt: 'desc' } });
  return NextResponse.json(tickets);
}

export async function POST(req: Request) {
  const data = await req.json();
  const ticket = await prisma.ticket.create({ data });
  return NextResponse.json(ticket);
}
