import { NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

export async function GET() {
  const users = await prisma.user.findMany();
  return NextResponse.json(users);
}

export async function POST(req: Request) {
  const data = await req.json();
  const user = await prisma.user.create({ data });
  return NextResponse.json(user);
}

export async function createUser(data: any) {
  return await prisma.user.create({ data });
}

export async function getUsers() {
  return await prisma.user.findMany();
}
