import { Metadata } from 'next'
import { getServerSession } from 'next-auth'
import { redirect } from 'next/navigation'
import ProjectCommunicationHub from '@/components/ProjectCommunicationHub'

export const metadata: Metadata = {
  title: 'Project Communication | NuwairSystems',
  description: 'Stay connected with your project teams and track project progress in real-time.',
}

export default async function ProjectCommunicationPage() {
  const session = await getServerSession()

  if (!session) {
    redirect('/auth/signin?callbackUrl=/dashboard/communication')
  }

  return <ProjectCommunicationHub />
}