'use client'

import { motion } from 'framer-motion'
import { CheckIcon, CpuChipIcon, ShieldCheckIcon, BoltIcon, ServerIcon } from '@heroicons/react/24/outline'
import Link from 'next/link'

const plans = [
  {
    name: 'XEON E3-1241 V3',
    price: '$87.88',
    period: 'month',
    features: [
      '4 cores @ 3.5 GHz',
      '16 GB DDR3',
      '2 x 480 GB SSD',
      '100 TB/mo Bandwidth'
    ],
    link: '/checkout?plan=dedicated-xeon-e3-1241'
  },
  {
    name: 'XEON E-2234',
    price: '$89.88',
    period: 'month',
    features: [
      '4 cores @ 3.4 GHz',
      '16 GB DDR4',
      '480 GB SSD',
      '100 TB/mo Bandwidth'
    ],
    link: '/checkout?plan=dedicated-xeon-e-2234'
  },
  {
    name: 'XEON E-2236',
    price: '$99.88',
    period: 'month',
    features: [
      '6 cores @ 3.4 GHz',
      '32 GB DDR4',
      '2 x 480 GB SSD',
      '100 TB/mo Bandwidth'
    ],
    popular: true,
    link: '/checkout?plan=dedicated-xeon-e-2236-32gb'
  },
  {
    name: 'XEON E-2236',
    price: '$109.88',
    period: 'month',
    features: [
      '6 cores @ 3.3 GHz',
      '64 GB DDR4',
      '2 x 960 GB SSD',
      '100 TB/mo Bandwidth'
    ],
    link: '/checkout?plan=dedicated-xeon-e-2236-64gb'
  },
  {
    name: 'DUAL XEON SILVER 4208',
    price: '$242.88',
    period: 'month',
    features: [
      'Dual 8 cores @ 2.1 GHz',
      '64 GB DDR4',
      '2 x 2 TB NVMe',
      'Unmetered Bandwidth'
    ],
    link: '/checkout?plan=dedicated-dual-xeon-silver'
  },
  {
    name: 'DUAL AMD EPYC 7282',
    price: '$299.88',
    period: 'month',
    features: [
      'Dual 16 cores @ 2.8 GHz',
      '128 GB DDR4',
      '4 x 1.92 TB NVMe',
      'Unmetered Bandwidth'
    ],
    link: '/checkout?plan=dedicated-dual-amd-epyc'
  }
]

const features = [
  'Same-Day Setup',
  'Free Migration',
  '99.99% Uptime'
]

const webPanels = [
  {
    name: 'InterWorx',
    description: 'Features NodeWorx (to manage a server) and SiteWorx (to manage a website, email hosting, and databases). Interworx makes it easy to migrate from other control panels such as SiteWorx, cPanel, DirectAdmin, Ensim, and Plesk 7-8.',
    features: [
      'Supports CentOS',
      'Allows for multiple Admin and User level access',
      'Includes unlimited accounts',
      'Fixed price of $28.00/month'
    ]
  },
  {
    name: 'cPanel',
    description: 'Simplify the management of your website from one single dashboard. cPanel lets you upload and manage files, create email accounts, and check the statistics of your website (e.g. the amount of visitors). Supports cPanel to cPanel website migration.',
    features: [
      'Supports CentOS, CloudLinux and AlmaLinux',
      'Only allows for Admin access',
      'The number of accounts is dependent on the tiers',
      'Starts at $19.88/month for Solo tier'
    ]
  }
]

export default function DedicatedServerPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 to-red-50/30">
      {/* Hero Section */}
      <section className="relative py-20 overflow-hidden bg-gradient-to-br from-red-600 via-rose-600 to-pink-600">
        <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAwIDEwIEwgMjAgMTAgTSAxMCAwIEwgMTAgMjAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjA1IiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-20"></div>
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
            className="text-center"
          >
            <motion.span
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: 0.2 }}
              className="inline-block px-4 py-2 rounded-full bg-white/20 text-white text-sm font-semibold mb-4"
            >
              FAST & SECURE
            </motion.span>
            
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              DEDICATED SERVER
            </h1>
            <p className="text-xl md:text-2xl text-white/90 mb-2">
              FOR EVERY PURPOSE
            </p>
            <p className="text-lg text-white/80 mb-8">
              THE BEST FULLY MANAGED DEDICATED HOSTING
            </p>
            
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4 }}
            >
              <Link
                href="/dedicated-server#plans"
                className="inline-block px-8 py-4 bg-white text-red-600 rounded-lg font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-200"
              >
                ORDER NOW
              </Link>
            </motion.div>
          </motion.div>
        </div>
      </section>

      {/* Description Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto">
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.6 }}
            >
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">DEDICATED SERVER</h2>
              <p className="text-lg text-gray-700 leading-relaxed mb-4">
                Affordable dedicated web hosting is a type of unlimited website hosting service where the customer rents an entire physical server from a affordable web hosting provider. This means that the customer has exclusive use of all the server's resources, including CPU, RAM, storage, and bandwidth.
              </p>
              <p className="text-lg text-gray-700 leading-relaxed mb-4">
                Dedicated server are ideal for businesses and individuals with high traffic websites, large-scale projects, or specialized needs that cannot be met by shared or vps hosting in pakistan.
              </p>
              <p className="text-lg text-gray-700 leading-relaxed">
                With dedicated server hosting, the customer has full control over the server and its configuration, including the ability to install their own operating system and applications, configure server settings, and access the server remotely. Dedicated server are typically more expensive than VPS or shared hosting, as the customer is responsible for the entire cost of the server. However, they offer the highest level of performance, security, and flexibility.
              </p>
            </motion.div>
          </div>
        </div>
      </section>

      {/* Pricing Plans */}
      <section className="py-16 bg-gradient-to-br from-gray-50 to-red-50/30">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              SELECT YOUR HOSTING PACKAGE
            </h2>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {plans.map((plan, index) => (
              <motion.div
                key={`${plan.name}-${index}`}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className={`relative bg-white rounded-xl shadow-lg overflow-hidden ${
                  plan.popular ? 'ring-2 ring-red-500 scale-105' : ''
                }`}
              >
                {plan.popular && (
                  <div className="absolute top-0 right-0 bg-red-500 text-white px-4 py-1 text-sm font-semibold rounded-bl-lg">
                    POPULAR
                  </div>
                )}
                
                <div className="p-6">
                  <h3 className="text-xl font-bold text-gray-900 mb-4">{plan.name}</h3>
                  <div className="mb-6">
                    <span className="text-4xl font-bold text-red-600">{plan.price}</span>
                    <span className="text-gray-600"> / {plan.period}</span>
                  </div>
                  
                  <ul className="space-y-3 mb-8">
                    {plan.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start gap-2 text-gray-700">
                        <CheckIcon className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                        <span className="text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                  
                  <Link
                    href={plan.link}
                    className="block w-full py-3 bg-gradient-to-r from-red-600 to-pink-600 text-white text-center font-semibold rounded-lg hover:shadow-lg hover:-translate-y-0.5 transition-all duration-200"
                  >
                    Order Now
                  </Link>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Pay Less Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-8"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">PAY LESS</h2>
            <p className="text-lg text-gray-700 mb-6">
              Get more power and control with your own dedicated server, all for an affordable price.
            </p>
            <div className="flex flex-wrap justify-center gap-6 mb-6">
              {features.map((feature, index) => (
                <div key={index} className="flex items-center gap-2">
                  <CheckIcon className="w-5 h-5 text-green-500" />
                  <span className="text-gray-700 font-semibold">{feature}</span>
                </div>
              ))}
            </div>
            <div className="text-2xl font-bold text-red-600">
              Start At 87.88<span className="text-lg">/month</span>
            </div>
          </motion.div>
        </div>
      </section>

      {/* Web Panels Section */}
      <section className="py-16 bg-gradient-to-br from-gray-50 to-red-50/30">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">WEB PANELS</h2>
            <p className="text-lg text-gray-600">INVEST IN A PHYSICAL SERVER THAT'S 100% YOURS</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
            {webPanels.map((panel, index) => (
              <motion.div
                key={panel.name}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.2 }}
                className="bg-white rounded-xl shadow-lg p-8"
              >
                <h3 className="text-2xl font-bold text-gray-900 mb-4">{panel.name}</h3>
                <p className="text-gray-700 leading-relaxed mb-6">{panel.description}</p>
                <ul className="space-y-3">
                  {panel.features.map((feature, idx) => (
                    <li key={idx} className="flex items-start gap-2 text-gray-700">
                      <CheckIcon className="w-5 h-5 text-red-500 flex-shrink-0 mt-0.5" />
                      <span>{feature}</span>
                    </li>
                  ))}
                </ul>
              </motion.div>
            ))}
          </div>

          {/* Additional Features */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="bg-white rounded-xl shadow-lg p-8"
          >
            <h3 className="text-2xl font-bold text-gray-900 mb-4">DATACENTER-POWERED RELIABILITY</h3>
            <p className="text-gray-700 leading-relaxed mb-6">
              Your Dedicated Server is hosted in the renowned PhoenixNAP datacenter, located in the US. From enterprise-level processors to ECC memory, you can count on the highest of standards and relax in the safest of hands.
            </p>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
              <div>
                <h4 className="text-xl font-bold text-gray-900 mb-3">24/7 Customer Support</h4>
                <p className="text-gray-700">
                  Have a question? Our dedicated team of technical experts is ready to answer. Depending on your Server Management type, they'll even perform software checks and provide support in case of emergency downtime.
                </p>
              </div>
              <div>
                <h4 className="text-xl font-bold text-gray-900 mb-3">Dedicated Server Level Choice</h4>
                <p className="text-gray-700">
                  Whether you run a small application, a medium-sized database or a high-traffic website, choose from Entry, Medium or Advanced levels to match your business needs.
                </p>
              </div>
            </div>
          </motion.div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-gradient-to-br from-red-600 via-rose-600 to-pink-600">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Ready for Maximum Power?
            </h2>
            <p className="text-xl text-white/90 mb-8">
              Choose your perfect dedicated server today
            </p>
            <Link
              href="/dedicated-server#plans"
              className="inline-block px-8 py-4 bg-white text-red-600 rounded-lg font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-200"
            >
              Get Started Now
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
