'use client'

import { motion } from 'framer-motion'
import { CheckIcon, GlobeAltIcon, ShieldCheckIcon, MagnifyingGlassIcon, ArrowPathIcon, LockClosedIcon } from '@heroicons/react/24/outline'
import Link from 'next/link'
import { useState } from 'react'

const tlds = [
  { extension: '.com', price: '$15.99', period: 'year', popular: true },
  { extension: '.net', price: '$17.99', period: 'year', popular: false },
  { extension: '.org', price: '$17.99', period: 'year', popular: false },
  { extension: '.pk', price: '$19.99', period: 'year', popular: true },
  { extension: '.co', price: '$29.99', period: 'year', popular: false },
  { extension: '.io', price: '$39.99', period: 'year', popular: false },
  { extension: '.info', price: '$14.99', period: 'year', popular: false },
  { extension: '.biz', price: '$16.99', period: 'year', popular: false },
]

const features = [
  {
    icon: GlobeAltIcon,
    title: 'Domain Registration',
    description: 'Register your perfect domain name with instant activation and worldwide accessibility.'
  },
  {
    icon: ArrowPathIcon,
    title: 'Domain Transfer',
    description: 'Transfer your existing domains easily with our seamless migration process.'
  },
  {
    icon: ShieldCheckIcon,
    title: 'Domain Privacy',
    description: 'Protect your personal information with WHOIS privacy protection.'
  },
  {
    icon: LockClosedIcon,
    title: 'Domain Lock',
    description: 'Secure your domain with domain lock to prevent unauthorized transfers.'
  },
  {
    icon: MagnifyingGlassIcon,
    title: 'DNS Management',
    description: 'Complete control over your domain DNS settings through our easy-to-use panel.'
  },
  {
    icon: CheckIcon,
    title: 'Free Features',
    description: 'Get free email forwarding, URL forwarding, and DNS management with every domain.'
  }
]

const benefits = [
  'Instant Domain Activation',
  'Free DNS Management',
  'Email Forwarding',
  'URL Forwarding',
  'Domain Lock Security',
  'Easy Control Panel',
  '24/7 Customer Support',
  'Competitive Pricing'
]

export default function DomainsPage() {
  const [searchDomain, setSearchDomain] = useState('')

  const handleSearch = (e: React.FormEvent) => {
    e.preventDefault()
    if (searchDomain.trim()) {
      window.location.href = `/checkout?type=domain&domain=${encodeURIComponent(searchDomain)}`
    }
  }

  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <section className="relative py-20 bg-slate-900">
        <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAwIDEwIEwgMjAgMTAgTSAxMCAwIEwgMTAgMjAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjA1IiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-10"></div>
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
            className="text-center"
          >
            <motion.span
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: 0.2 }}
              className="inline-block px-4 py-2 rounded-full bg-blue-50 text-blue-600 text-sm font-semibold mb-4"
            >
              Domain Registration
            </motion.span>
            
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              Domain Name Registration
            </h1>
            <p className="text-xl md:text-2xl text-slate-300 mb-8">
              Secure your perfect domain name today
            </p>
            
            {/* Domain Search */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4 }}
              className="max-w-3xl mx-auto"
            >
              <form onSubmit={handleSearch} className="flex flex-col sm:flex-row gap-4">
                <div className="flex-1 relative">
                  <input
                    type="text"
                    value={searchDomain}
                    onChange={(e) => setSearchDomain(e.target.value)}
                    placeholder="Search for your perfect domain name..."
                    className="w-full px-6 py-4 rounded-lg text-slate-900 text-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                  />
                  <MagnifyingGlassIcon className="absolute right-4 top-1/2 -translate-y-1/2 w-6 h-6 text-slate-400" />
                </div>
                <button
                  type="submit"
                  className="px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-lg shadow-lg hover:bg-blue-700 transition-colors duration-200 whitespace-nowrap"
                >
                  Search Domain
                </button>
              </form>
            </motion.div>
          </motion.div>
        </div>
      </section>

      {/* TLD Pricing Section */}
      <section className="py-16 bg-slate-50 border-y border-slate-200">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <div className="inline-flex items-center px-4 py-2 bg-blue-50 text-blue-600 rounded-full text-sm font-semibold mb-4">
              Domain Pricing
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-4">
              Competitive Domain Pricing
            </h2>
            <p className="text-lg text-slate-600">Choose from popular domain extensions</p>
          </motion.div>

          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            {tlds.map((tld, index) => (
              <motion.div
                key={tld.extension}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.05 }}
                className={`bg-white rounded-xl p-6 text-center border-2 ${
                  tld.popular ? 'border-blue-600 shadow-lg' : 'border-slate-200'
                }`}
              >
                {tld.popular && (
                  <div className="inline-block px-3 py-1 bg-blue-600 text-white text-xs font-semibold rounded-full mb-3">
                    POPULAR
                  </div>
                )}
                <div className="text-3xl font-bold text-slate-900 mb-2">{tld.extension}</div>
                <div className="mb-4">
                  <span className="text-3xl font-bold text-slate-900">{tld.price}</span>
                  <span className="text-slate-600"> / {tld.period}</span>
                </div>
                <Link
                  href={`/checkout?type=domain&ext=${tld.extension}`}
                  className="block w-full py-2 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition-colors duration-200"
                >
                  Register Now
                </Link>
              </motion.div>
            ))}
          </div>

          <motion.div
            initial={{ opacity: 0 }}
            whileInView={{ opacity: 1 }}
            viewport={{ once: true }}
            className="text-center mt-8"
          >
            <p className="text-slate-600 mb-4">Looking for more domain extensions?</p>
            <Link
              href="/checkout?type=domain"
              className="inline-block px-6 py-3 bg-slate-900 text-white rounded-lg font-semibold hover:bg-slate-800 transition-colors"
            >
              View All TLDs
            </Link>
          </motion.div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <div className="inline-flex items-center px-4 py-2 bg-blue-50 text-blue-600 rounded-full text-sm font-semibold mb-4">
              Features
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-4">
              Comprehensive Domain Features
            </h2>
            <p className="text-lg text-slate-600">Everything you need for your domain</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => (
              <motion.div
                key={feature.title}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="bg-white rounded-xl border border-slate-200 p-6 hover:shadow-md transition-shadow duration-200"
              >
                <div className="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mb-4">
                  <feature.icon className="w-6 h-6 text-blue-600" />
                </div>
                <h3 className="text-xl font-bold text-slate-900 mb-2">{feature.title}</h3>
                <p className="text-slate-600">{feature.description}</p>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Benefits Section */}
      <section className="py-16 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <div className="inline-flex items-center px-4 py-2 bg-blue-50 text-blue-600 rounded-full text-sm font-semibold mb-4">
              Why Choose Us
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-4">
              Professional Domain Services
            </h2>
            <p className="text-lg text-slate-600">For your domain registration needs</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {benefits.map((benefit, index) => (
              <motion.div
                key={benefit}
                initial={{ opacity: 0, x: -20 }}
                whileInView={{ opacity: 1, x: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.05 }}
                className="flex items-center gap-3 bg-white p-4 rounded-lg border border-slate-200"
              >
                <CheckIcon className="w-6 h-6 text-blue-600 flex-shrink-0" />
                <span className="text-slate-900 font-semibold">{benefit}</span>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Domain Transfer Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="bg-slate-50 rounded-2xl border border-slate-200 p-8 md:p-12"
          >
            <div className="grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
              <div>
                <div className="inline-flex items-center px-4 py-2 bg-blue-50 text-blue-600 rounded-full text-sm font-semibold mb-6">
                  Domain Transfer
                </div>
                <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-4">
                  Transfer Your Domain
                </h2>
                <p className="text-lg text-slate-600 mb-6">
                  Already have a domain? Transfer it to Nuwair Systems and enjoy better pricing, free privacy protection, and superior customer support.
                </p>
                <ul className="space-y-3 mb-6">
                  <li className="flex items-start gap-2">
                    <CheckIcon className="w-6 h-6 text-blue-600 flex-shrink-0 mt-0.5" />
                    <span className="text-slate-700">Easy transfer process</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <CheckIcon className="w-6 h-6 text-blue-600 flex-shrink-0 mt-0.5" />
                    <span className="text-slate-700">Free 1-year extension on transfer</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <CheckIcon className="w-6 h-6 text-blue-600 flex-shrink-0 mt-0.5" />
                    <span className="text-slate-700">No downtime during transfer</span>
                  </li>
                  <li className="flex items-start gap-2">
                    <CheckIcon className="w-6 h-6 text-blue-600 flex-shrink-0 mt-0.5" />
                    <span className="text-slate-700">Free domain privacy protection</span>
                  </li>
                </ul>
                <Link
                  href="/checkout?type=domain-transfer"
                  className="inline-block px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-lg shadow-lg hover:bg-blue-700 transition-colors duration-200"
                >
                  Transfer Your Domain
                </Link>
              </div>
              <div className="relative">
                <div className="bg-slate-900 rounded-2xl p-8 text-white">
                  <div className="w-16 h-16 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                    <ArrowPathIcon className="w-10 h-10" />
                  </div>
                  <h3 className="text-2xl font-bold mb-2">Quick Transfer</h3>
                  <p className="text-slate-300">
                    Transfer your domain in just a few simple steps. Our support team is ready to assist you throughout the entire process.
                  </p>
                </div>
              </div>
            </div>
          </motion.div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-slate-900">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Ready to Get Your Domain?
            </h2>
            <p className="text-xl text-slate-300 mb-8">
              Register your perfect domain name today and start building your online presence
            </p>
            <Link
              href="/checkout?type=domain"
              className="inline-block px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-lg shadow-lg hover:bg-blue-700 transition-colors duration-200"
            >
              Search Domains Now
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
