'use client'

import { useEffect } from 'react'
import Link from 'next/link'
import { ExclamationTriangleIcon, HomeIcon } from '@heroicons/react/24/outline'

export default function Error({
  error,
  reset,
}: {
  error: Error & { digest?: string }
  reset: () => void
}) {
  useEffect(() => {
    console.error(error)
  }, [error])

  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-indigo-900 flex items-center justify-center px-4">
      <div className="max-w-md mx-auto text-center">
        <div className="bg-white/10 backdrop-blur-md rounded-3xl p-8 border border-white/20 shadow-2xl">
          <ExclamationTriangleIcon className="w-16 h-16 text-yellow-400 mx-auto mb-6" />
          
          <h1 className="text-2xl font-bold text-white mb-4">
            Oops! Something went wrong
          </h1>
          
          <p className="text-gray-300 mb-8">
            We encountered an unexpected error. Don't worry, our team has been notified and we're working on a fix.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button
              onClick={() => reset()}
              className="bg-gradient-to-r from-blue-600 to-purple-600 text-white px-6 py-3 rounded-lg font-semibold hover:from-blue-700 hover:to-purple-700 transition-all duration-300"
            >
              Try Again
            </button>
            
            <Link
              href="/"
              className="border-2 border-cyan-400 text-cyan-400 hover:bg-cyan-400 hover:text-gray-900 px-6 py-3 rounded-lg font-semibold transition-all duration-300 flex items-center justify-center"
            >
              <HomeIcon className="w-5 h-5 mr-2" />
              Go Home
            </Link>
          </div>
          
          <p className="text-sm text-gray-400 mt-6">
            Need immediate help? Contact us at{' '}
            <a href="mailto:support@nuwairsystems.com" className="text-cyan-400 hover:underline">
              support@nuwairsystems.com
            </a>
          </p>
        </div>
      </div>
    </div>
  )
}