import { Metadata } from 'next'
import { getServerSession } from 'next-auth'
import { redirect } from 'next/navigation'
import AutomatedInvoicing from '@/components/AutomatedInvoicing'

export const metadata: Metadata = {
  title: 'Invoice Management | NuwairSystems',
  description: 'Create, manage, and track invoices with automated billing and recurring payments.',
}

export default async function InvoicesPage() {
  const session = await getServerSession()

  if (!session) {
    redirect('/auth/signin?callbackUrl=/invoices')
  }

  return <AutomatedInvoicing />
}