import Link from 'next/link'
import { HomeIcon, MagnifyingGlassIcon } from '@heroicons/react/24/outline'

export default function NotFound() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-900 via-blue-900 to-indigo-900 flex items-center justify-center px-4">
      <div className="max-w-lg mx-auto text-center">
        <div className="bg-white/10 backdrop-blur-md rounded-3xl p-12 border border-white/20 shadow-2xl">
          {/* 404 Number */}
          <div className="text-8xl font-bold bg-gradient-to-r from-cyan-400 to-purple-400 bg-clip-text text-transparent mb-6">
            404
          </div>
          
          <h1 className="text-3xl font-bold text-white mb-4">
            Page Not Found
          </h1>
          
          <p className="text-xl text-gray-300 mb-8">
            The page you're looking for doesn't exist. It might have been moved, deleted, or you entered the wrong URL.
          </p>
          
          {/* Action buttons */}
          <div className="flex flex-col sm:flex-row gap-4 justify-center mb-8">
            <Link
              href="/"
              className="bg-gradient-to-r from-blue-600 to-purple-600 text-white px-8 py-4 rounded-xl font-semibold hover:from-blue-700 hover:to-purple-700 transition-all duration-300 flex items-center justify-center"
            >
              <HomeIcon className="w-5 h-5 mr-2" />
              Back to Home
            </Link>
            
            <Link
              href="/services"
              className="border-2 border-cyan-400 text-cyan-400 hover:bg-cyan-400 hover:text-gray-900 px-8 py-4 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center"
            >
              <MagnifyingGlassIcon className="w-5 h-5 mr-2" />
              Browse Services
            </Link>
          </div>
          
          {/* Popular links */}
          <div className="text-left">
            <h3 className="text-lg font-semibold text-white mb-4">Popular Pages:</h3>
            <div className="grid grid-cols-1 gap-2">
              <Link href="/services" className="text-cyan-400 hover:text-cyan-300 transition-colors">
                → Our Services & Hosting Plans
              </Link>
              <Link href="/contact" className="text-cyan-400 hover:text-cyan-300 transition-colors">
                → Contact Us
              </Link>
              <Link href="/blog" className="text-cyan-400 hover:text-cyan-300 transition-colors">
                → Blog & Resources
              </Link>
            </div>
          </div>
          
          <div className="mt-8 pt-6 border-t border-white/20">
            <p className="text-sm text-gray-400">
              Still need help? Contact us at{' '}
              <a href="mailto:support@nuwairsystems.com" className="text-cyan-400 hover:underline">
                support@nuwairsystems.com
              </a>
            </p>
          </div>
        </div>
      </div>
    </div>
  )
}