
import Hero from '@/components/sections/Hero'
import Stats from '@/components/sections/Stats'
import Services from '@/components/sections/Services'
import WhyChooseUs from '@/components/sections/WhyChooseUs'
import Contact from '@/components/sections/Contact'
import TestimonialsSlider from '@/components/TestimonialsSlider'


export default function Home() {
  return (
    <div className="flex flex-col relative">
      {/* Hero Section */}
      <Hero />

      {/* Stats/Domain Section */}
      <Stats />

      {/* Services Section */}
      <div className="bg-gradient-to-br from-white via-blue-50/30 to-purple-50/30">
        <Services />
      </div>


      {/* Why Choose Us */}
      <div className="bg-gradient-to-br from-indigo-50/50 via-purple-50/30 to-pink-50/30">
        <WhyChooseUs />
      </div>

      {/* Testimonials Slider */}
      <div className="bg-white py-16">
        <TestimonialsSlider />
      </div>

      {/* Contact */}
      <div className="bg-gradient-to-br from-blue-50 via-indigo-50 to-purple-50">
        <Contact />
      </div>
    </div>
  )
}
