import { Metadata } from 'next'
import { getServerSession } from 'next-auth'
import { redirect } from 'next/navigation'
import AdvancedPaymentGateway from '@/components/AdvancedPaymentGateway'

export const metadata: Metadata = {
  title: 'Payment Gateway | NuwairSystems',
  description: 'Secure payment processing with multiple payment options including local Pakistani methods.',
}

export default async function PaymentGatewayPage() {
  const session = await getServerSession()

  if (!session) {
    redirect('/auth/signin?callbackUrl=/payments')
  }

  return (
    <div className="min-h-screen bg-gray-50 py-8">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="mb-8 text-center">
          <h1 className="text-3xl font-bold text-gray-900">Payment Gateway</h1>
          <p className="text-gray-600 mt-2">
            Secure and convenient payment options for all your services
          </p>
        </div>
        
        <AdvancedPaymentGateway 
          amount={25000}
          description="Service payment for NuwairSystems"
          onSuccess={(data) => {
            console.log('Payment successful:', data)
            // Handle success redirect
          }}
          onError={(error) => {
            console.error('Payment failed:', error)
            // Handle error
          }}
        />
      </div>
    </div>
  )
}