'use client'

import { motion } from 'framer-motion'
import { 
  ShieldCheckIcon, 
  LockClosedIcon, 
  UserGroupIcon,
  DocumentTextIcon,
  GlobeAltIcon,
  BellAlertIcon
} from '@heroicons/react/24/outline'
import Link from 'next/link'

export default function PrivacyPolicy() {
  const sections = [
    {
      icon: UserGroupIcon,
      title: '1. Information We Collect',
      content: 'We collect information you provide directly (name, email, phone, billing information), automatically (IP address, browser type, cookies), and from third parties (payment processors). This helps us provide and improve our services.'
    },
    {
      icon: LockClosedIcon,
      title: '2. How We Use Your Information',
      content: 'We use your information to provide services, process payments, communicate with you, improve our services, ensure security, and comply with legal obligations. We never sell your personal information to third parties.'
    },
    {
      icon: GlobeAltIcon,
      title: '3. Information Sharing',
      content: 'We share information only with service providers (payment processors, hosting infrastructure), for legal compliance, business transfers, or with your consent. All third parties are bound by confidentiality agreements.'
    },
    {
      icon: ShieldCheckIcon,
      title: '4. Data Security',
      content: 'We implement industry-standard security measures including SSL encryption, secure data centers, regular security audits, and access controls. However, no method of transmission over the Internet is 100% secure.'
    },
    {
      icon: DocumentTextIcon,
      title: '5. Your Rights (GDPR)',
      content: 'You have the right to access, correct, delete, port, and restrict processing of your data. You can object to processing and withdraw consent. Contact us to exercise these rights. We respond within 30 days.'
    },
    {
      icon: BellAlertIcon,
      title: '6. Cookies and Tracking',
      content: 'We use cookies for authentication, preferences, analytics, and advertising. You can control cookies through browser settings. Essential cookies are required for basic functionality and cannot be disabled.'
    },
    {
      title: '7. Data Retention',
      content: 'We retain personal data for as long as necessary to provide services, comply with legal obligations, resolve disputes, and enforce agreements. Active accounts are retained indefinitely; closed accounts are deleted after 90 days.'
    },
    {
      title: '8. International Transfers',
      content: 'Your data may be transferred to and processed in countries outside your residence. We ensure appropriate safeguards are in place for international transfers, including standard contractual clauses and adequacy decisions.'
    },
    {
      title: '9. Children\'s Privacy',
      content: 'Our services are not directed to individuals under 18. We do not knowingly collect information from children. If we learn we have collected information from a child, we will delete it immediately.'
    },
    {
      title: '10. Third-Party Links',
      content: 'Our services may contain links to third-party websites. We are not responsible for their privacy practices. We encourage you to review the privacy policies of any third-party sites you visit.'
    },
    {
      title: '11. Data Breach Notification',
      content: 'In the event of a data breach, we will notify affected users and relevant authorities within 72 hours as required by GDPR. We will provide information about the breach and steps taken to address it.'
    },
    {
      title: '12. Changes to Privacy Policy',
      content: 'We may update this policy periodically. We will notify you of significant changes via email or prominent notice on our website. Your continued use after changes constitutes acceptance of the updated policy.'
    },
    {
      title: '13. Contact & Data Protection Officer',
      content: 'For privacy concerns, contact our Data Protection Officer at privacy@nuwair.com or call +92 3111 689 247. We respond to all privacy inquiries within 48 hours during business days.'
    }
  ]

  return (
    <div className="min-h-screen bg-gradient-to-b from-slate-50 to-white">
      {/* Hero Section */}
      <section className="bg-slate-900 text-white py-20">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            className="text-center"
          >
            <div className="flex justify-center mb-6">
              <div className="rounded-full bg-blue-600/10 p-4">
                <ShieldCheckIcon className="w-12 h-12 text-blue-400" />
              </div>
            </div>
            <h1 className="text-4xl md:text-5xl font-bold mb-6">
              Privacy Policy
            </h1>
            <p className="text-xl text-slate-300 mb-4">
              Last Updated: November 13, 2025
            </p>
            <p className="text-lg text-slate-400 max-w-2xl mx-auto">
              Your privacy is important to us. This policy explains how we collect, use, 
              and protect your personal information in compliance with GDPR and international standards.
            </p>
          </motion.div>
        </div>
      </section>

      {/* Quick Summary */}
      <section className="py-12 bg-blue-50">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.2 }}
            className="bg-white rounded-xl shadow-sm border border-blue-200 p-8"
          >
            <h2 className="text-2xl font-bold text-slate-900 mb-6 text-center">
              Privacy at a Glance
            </h2>
            <div className="grid md:grid-cols-3 gap-6">
              <div className="text-center">
                <div className="rounded-full bg-blue-100 w-16 h-16 flex items-center justify-center mx-auto mb-3">
                  <LockClosedIcon className="w-8 h-8 text-blue-600" />
                </div>
                <h3 className="font-semibold text-slate-900 mb-2">Secure</h3>
                <p className="text-sm text-slate-600">SSL encryption & secure data centers</p>
              </div>
              <div className="text-center">
                <div className="rounded-full bg-blue-100 w-16 h-16 flex items-center justify-center mx-auto mb-3">
                  <ShieldCheckIcon className="w-8 h-8 text-blue-600" />
                </div>
                <h3 className="font-semibold text-slate-900 mb-2">GDPR Compliant</h3>
                <p className="text-sm text-slate-600">Full compliance with EU regulations</p>
              </div>
              <div className="text-center">
                <div className="rounded-full bg-blue-100 w-16 h-16 flex items-center justify-center mx-auto mb-3">
                  <UserGroupIcon className="w-8 h-8 text-blue-600" />
                </div>
                <h3 className="font-semibold text-slate-900 mb-2">Your Control</h3>
                <p className="text-sm text-slate-600">Full access, edit & delete rights</p>
              </div>
            </div>
          </motion.div>
        </div>
      </section>

      {/* Quick Links */}
      <section className="py-6 bg-white border-b border-slate-200">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex flex-wrap gap-4 justify-center">
            <Link 
              href="/terms"
              className="inline-flex items-center px-4 py-2 bg-slate-100 text-slate-700 rounded-lg hover:bg-slate-200 transition-colors"
            >
              <DocumentTextIcon className="w-5 h-5 mr-2" />
              Terms of Service
            </Link>
            <a 
              href="mailto:privacy@nuwair.com"
              className="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors"
            >
              Contact Privacy Team
            </a>
          </div>
        </div>
      </section>

      {/* Privacy Policy Content */}
      <section className="py-16">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-8">
            {sections.map((section, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: index * 0.05 }}
                className="bg-white rounded-xl shadow-sm border border-slate-200 p-8 hover:shadow-md transition-shadow"
              >
                <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-start">
                  {section.icon && <section.icon className="w-6 h-6 text-blue-600 mr-3 flex-shrink-0 mt-1" />}
                  {section.title}
                </h2>
                <p className="text-slate-700 leading-relaxed">
                  {section.content}
                </p>
              </motion.div>
            ))}
          </div>

          {/* GDPR Rights Highlight */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.8 }}
            className="mt-12 bg-gradient-to-r from-blue-50 to-indigo-50 border border-blue-200 rounded-xl p-8"
          >
            <div className="flex items-start">
              <ShieldCheckIcon className="w-8 h-8 text-blue-600 mr-4 flex-shrink-0" />
              <div>
                <h3 className="text-xl font-bold text-slate-900 mb-3">
                  Your Data Rights Under GDPR
                </h3>
                <ul className="space-y-2 text-slate-700">
                  <li className="flex items-start">
                    <span className="text-blue-600 mr-2">✓</span>
                    <span><strong>Right to Access:</strong> Request a copy of your personal data</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-blue-600 mr-2">✓</span>
                    <span><strong>Right to Rectification:</strong> Correct inaccurate information</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-blue-600 mr-2">✓</span>
                    <span><strong>Right to Erasure:</strong> Request deletion of your data</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-blue-600 mr-2">✓</span>
                    <span><strong>Right to Data Portability:</strong> Receive your data in a portable format</span>
                  </li>
                  <li className="flex items-start">
                    <span className="text-blue-600 mr-2">✓</span>
                    <span><strong>Right to Object:</strong> Object to data processing</span>
                  </li>
                </ul>
                <p className="text-slate-700 mt-4">
                  To exercise these rights, contact us at{' '}
                  <a href="mailto:privacy@nuwair.com" className="text-blue-600 hover:text-blue-700 font-medium">
                    privacy@nuwair.com
                  </a>
                </p>
              </div>
            </div>
          </motion.div>

          {/* Contact CTA */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.9 }}
            className="mt-12 text-center"
          >
            <Link
              href="/contact"
              className="inline-flex items-center px-8 py-4 bg-slate-900 text-white rounded-lg font-semibold hover:bg-slate-800 transition-colors shadow-lg hover:shadow-xl"
            >
              Questions About Your Privacy?
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
