'use client'

import { motion } from 'framer-motion'
import { CheckIcon, ServerStackIcon, ShieldCheckIcon, BoltIcon, ClockIcon, GlobeAltIcon } from '@heroicons/react/24/outline'
import Link from 'next/link'

const plans = [
  {
    name: 'BASIC',
    price: '$11.99',
    period: 'month',
    features: [
      '1 Core vCPU Processor',
      '1.5 GB Guaranteed RAM',
      '25 GB Cloud Storage Space',
      '25 cPanel Accounts',
      '800 GB Premium Bandwidth',
      'LiteSpeed Included',
      'Free SSL Certificates',
      'Patchman Optional',
      'cPanel/WHM Reseller'
    ],
    note: 'Based on 3 year commitment',
    link: '/checkout?plan=reseller-basic'
  },
  {
    name: 'STANDARD',
    price: '$19.97',
    period: 'month',
    features: [
      '1 Core vCPU Processor',
      '2 GB Guaranteed RAM',
      '50 GB Cloud Storage Space',
      '50 cPanel Accounts',
      '1200 GB Premium Bandwidth',
      'LiteSpeed Included',
      'Free SSL Certificates',
      'Patchman Optional',
      'cPanel/WHM Reseller'
    ],
    popular: true,
    link: '/checkout?plan=reseller-standard'
  },
  {
    name: 'PROFESSIONAL',
    price: '$28.97',
    period: 'month',
    features: [
      '2 Core vCPU Processor',
      '3 GB Guaranteed RAM',
      '100 GB Cloud Storage Space',
      '75 cPanel Accounts',
      '1600 GB Premium Bandwidth',
      'LiteSpeed Included',
      'Free SSL Certificates',
      'Patchman Optional',
      'cPanel/WHM Reseller'
    ],
    link: '/checkout?plan=reseller-professional'
  },
  {
    name: 'PREMIUM',
    price: '$56.47',
    period: 'month',
    features: [
      '3 Core vCPU Processor',
      '4 GB Guaranteed RAM',
      '200 GB Cloud Storage Space',
      '100 cPanel Accounts',
      '4000 GB Premium Bandwidth',
      'LiteSpeed Included',
      'Free SSL Certificates',
      'Patchman Optional',
      'cPanel/WHM Reseller'
    ],
    link: '/checkout?plan=reseller-premium'
  }
]

const features = [
  'State-of-the-Art Platforms',
  'Industry Best Uptimes (99.99+%)',
  'No Hidden Charges or Fees',
  '24/7/365 World-Class Support',
  'Litespeed/LSCache Powered'
]

export default function ResellerHostingPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 to-green-50/30">
      {/* Hero Section */}
      <section className="relative py-20 overflow-hidden bg-gradient-to-br from-green-600 via-emerald-600 to-teal-600">
        <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAwIDEwIEwgMjAgMTAgTSAxMCAwIEwgMTAgMjAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjA1IiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-20"></div>
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
            className="text-center"
          >
            <motion.span
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: 0.2 }}
              className="inline-block px-4 py-2 rounded-full bg-white/20 text-white text-sm font-semibold mb-4"
            >
              FAST & SECURE
            </motion.span>
            
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              RESELLER HOSTING
            </h1>
            <p className="text-xl md:text-2xl text-white/90 mb-2">
              Hosting in Pakistan
            </p>
            <p className="text-lg text-white/80 mb-8">
              THE BEST FULLY MANAGED Reseller Hosting
            </p>
            
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4 }}
            >
              <Link
                href="/reseller-hosting#plans"
                className="inline-block px-8 py-4 bg-white text-green-600 rounded-lg font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-200"
              >
                ORDER NOW
              </Link>
            </motion.div>
          </motion.div>
        </div>
      </section>

      {/* Description */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto">
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
            >
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">RESELLER HOSTING</h2>
              <p className="text-lg text-gray-700 leading-relaxed mb-4">
                Reseller hosting is a type of hosting in Pakistan where a person or company buys a large amount of dedicated server space from an affordable web hosting provider and then sells it to their own customers.
              </p>
              <p className="text-lg text-gray-700 leading-relaxed">
                The reseller manages their customers' websites, while the hosting provider takes care of the main server and technical support. This is a good option for those who want to start their own hosting business or offer hosting services in Pakistan as an extra service.
              </p>
            </motion.div>
          </div>
        </div>
      </section>

      {/* Pricing Plans */}
      <section className="py-16 bg-gradient-to-br from-gray-50 to-green-50/30">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              RESELLER HOSTING PACKAGE
            </h2>
            <p className="text-lg text-gray-600">JUST RIGHT FOR YOUR BUSINESS</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {plans.map((plan, index) => (
              <motion.div
                key={plan.name}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className={`relative bg-white rounded-xl shadow-lg overflow-hidden ${
                  plan.popular ? 'ring-2 ring-green-500 scale-105' : ''
                }`}
              >
                {plan.popular && (
                  <div className="absolute top-0 right-0 bg-green-500 text-white px-4 py-1 text-sm font-semibold rounded-bl-lg">
                    POPULAR
                  </div>
                )}
                
                <div className="p-6">
                  <h3 className="text-2xl font-bold text-gray-900 mb-4">{plan.name}</h3>
                  <div className="mb-6">
                    <span className="text-4xl font-bold text-green-600">{plan.price}</span>
                    <span className="text-gray-600"> / {plan.period}</span>
                  </div>
                  
                  <ul className="space-y-3 mb-8">
                    {plan.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start gap-2 text-gray-700">
                        <CheckIcon className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                        <span className="text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                  
                  {plan.note && (
                    <p className="text-xs text-gray-500 mb-4">* {plan.note}</p>
                  )}
                  
                  <Link
                    href={plan.link}
                    className="block w-full py-3 bg-gradient-to-r from-green-600 to-emerald-600 text-white text-center font-semibold rounded-lg hover:shadow-lg hover:-translate-y-0.5 transition-all duration-200"
                  >
                    Order Now
                  </Link>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Features */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-8">
              THE BASICS
            </h2>
            <p className="text-lg text-gray-700 max-w-4xl mx-auto leading-relaxed mb-8">
              Cheap Reseller Hosting Pakistan is a great way for agencies to serve their customers without worrying about dedicated server low cost. With free white label hosting reseller options, you can offer hosting under your own brand.
            </p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
            {features.map((feature, index) => (
              <motion.div
                key={feature}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className="bg-gradient-to-br from-green-50 to-emerald-50 rounded-xl p-6 text-center"
              >
                <CheckIcon className="w-8 h-8 text-green-600 mx-auto mb-3" />
                <p className="text-gray-800 font-semibold">{feature}</p>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-16 bg-gradient-to-br from-green-600 via-emerald-600 to-teal-600">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Start Your Hosting Business Today
            </h2>
            <p className="text-xl text-white/90 mb-8">
              Join thousands of successful resellers worldwide
            </p>
            <Link
              href="/reseller-hosting#plans"
              className="inline-block px-8 py-4 bg-white text-green-600 rounded-lg font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-200"
            >
              Get Started Now
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
