'use client'

import { useState } from 'react'
import Link from 'next/link'
import { motion } from 'framer-motion'
import { 
  CheckCircleIcon, 
  ClockIcon, 
  CurrencyDollarIcon,
  ArrowLeftIcon,
  MagnifyingGlassIcon,
  ChartBarIcon,
  DocumentMagnifyingGlassIcon,
  LinkIcon,
  Cog6ToothIcon,
  PresentationChartLineIcon,
  MapPinIcon,
  ChatBubbleLeftRightIcon,
  ShieldCheckIcon,
  ArrowTrendingUpIcon,
  UserGroupIcon,
  ClipboardDocumentCheckIcon,
  EyeIcon
} from '@heroicons/react/24/outline'
import { useCartStore } from '@/store/cart'

export default function SEOOptimizationPage() {
  const addToCart = useCartStore((state) => state.addToCart)
  const openCart = useCartStore((state) => state.openCart)

  const handleAddToCart = () => {
    addToCart({
      id: 8,
      title: 'SEO Optimization',
      price: 800,
      quantity: 1
    })
    
    setTimeout(() => {
      openCart()
    }, 100)
  }

  const mainServices = [
    {
      icon: ArrowTrendingUpIcon,
      title: 'Rank Higher on Google',
      description: 'We specialize in boosting your Google rankings through expert SEO services, maximizing your online visibility and driving organic traffic.'
    },
    {
      icon: ChartBarIcon,
      title: 'Increase Website Traffic',
      description: 'Our mission is to increase your website traffic. With our SEO services, we optimize your online presence to attract more visitors and grow your business.'
    },
    {
      icon: UserGroupIcon,
      title: 'Qualified Lead Generation',
      description: 'We employ targeted SEO strategies and analytics insights to attract genuinely interested potential customers, maximizing your conversion opportunities.'
    },
    {
      icon: CurrencyDollarIcon,
      title: 'Improve ROI & Increase Revenue',
      description: 'With our SEO services, we drive qualified traffic and optimize conversions to deliver tangible business growth and success.'
    }
  ]

  const features = [
    'On-Page & Off-Page SEO',
    'Bespoke SEO Packages',
    'Dedicated SEO Consultants',
    'Monthly Technical Audits',
    'Fully Tailored Approach',
    'Fixed Fee SEO Retainers',
    'Constant Monitoring',
    '200+ Signals Monitored',
    'SERP Tracking',
    'Keyword Analysis',
    'Google Trend Monitoring',
    'Ongoing Reporting',
    'White-Hat Safe Techniques',
    'One-To-One Support'
  ]

  const detailedServices = [
    {
      icon: DocumentMagnifyingGlassIcon,
      title: 'Website SEO Audits',
      description: 'Enhance your website\'s performance and search engine visibility with our thorough technical SEO audits. Our expert team conducts in-depth analyses to identify and fix technical issues that impact your site\'s rankings.',
      details: 'From website structure and crawlability to site speed and indexing, we provide actionable recommendations to optimize your site for improved organic traffic and higher search engine rankings. Maximize your search engine optimization potential with our comprehensive website SEO audits.'
    },
    {
      icon: MagnifyingGlassIcon,
      title: 'Keyword & Content Strategy',
      description: 'Unlock the power of keywords and compelling content with our comprehensive Keyword & Content Strategy services. Our expert team conducts thorough research to identify strategic keywords.',
      details: 'From optimizing on-page content to developing engaging blog posts, we ensure your website ranks higher, attracts organic traffic, and drives conversions. Supercharge your SEO with our effective Keyword & Content Strategy services.'
    },
    {
      icon: LinkIcon,
      title: 'Link Building',
      description: 'Boost your website\'s authority and search engine rankings with our professional Link Building services. Our skilled team utilizes proven strategies to secure high-quality backlinks.',
      details: 'Through strategic outreach and content promotion, we generate relevant and valuable links that drive organic traffic and improve your SEO performance. We can also help remove harmful, low-quality links to assist with Google penalty recovery.'
    },
    {
      icon: Cog6ToothIcon,
      title: 'On-Page SEO & UX Changes',
      description: 'Our dedicated team will conduct a meticulous analysis of your website, implementing strategic optimizations to improve keyword targeting, meta tags, and internal linking.',
      details: 'By aligning your website with best practices, we enhance search engine visibility and ensure a seamless browsing experience, resulting in increased organic traffic and higher conversion rates.'
    },
    {
      icon: ShieldCheckIcon,
      title: 'Google Algorithm Updates',
      description: 'Since Google\'s algorithm is constantly changing, our team diligently monitors algorithm changes and Google Search volatility and their impact on search rankings.',
      details: 'We adapt your SEO strategies accordingly, ensuring your website remains compliant and maintains its visibility in search results. With our expertise, you can navigate algorithm updates with confidence.'
    },
    {
      icon: ClipboardDocumentCheckIcon,
      title: 'Content Gap Analysis',
      description: 'Uncover opportunities for growth and outperform your competitors with our Content Gap Analysis service. We identify gaps in content coverage through comprehensive analysis.',
      details: 'By understanding what your competitors are ranking for, we develop a data-driven content strategy that fills those gaps, targeting relevant keywords and capturing valuable organic traffic.'
    },
    {
      icon: MapPinIcon,
      title: 'Local SEO Specialists',
      description: 'Dominate the local search results and attract more customers with our expert Local SEO specialists. We optimize your online presence for local searches.',
      details: 'We employ targeted strategies such as local keyword optimization, citation building, and review management to enhance your local visibility and connect you with potential customers in your target area.'
    },
    {
      icon: PresentationChartLineIcon,
      title: 'Monthly Reporting & Communication',
      description: 'Stay informed and empowered with our Monthly Reporting & Communication service. We provide comprehensive reports detailing the performance of your SEO campaigns.',
      details: 'We schedule regular communication sessions to discuss progress, address concerns, and align strategies with your business goals. With transparent reporting and proactive communication, you have a clear understanding of results.'
    }
  ]

  const faqs = [
    {
      question: 'How long does SEO take?',
      answer: 'Determining how long SEO takes depends on your website and over 200 signals that Google checks and monitors. In most cases, you should expect to see positive results within the first 3 months of running your long-term campaign.'
    },
    {
      question: 'How regularly do you report back to clients?',
      answer: 'We have weekly calls with every client, a full report once a month, and regular meetings whenever they are needed.'
    },
    {
      question: 'Do you limit the amount of keywords you focus on?',
      answer: 'No. Before going ahead with SEO with us, we will present a comprehensive audit of our initial ideas and focuses. We do not limit you to just a few keywords to focus on.'
    },
    {
      question: 'How much does SEO cost?',
      answer: 'Typically our SEO packages start at $800 per month, but this depends on your website and goals of the campaign.'
    }
  ]

  const process = [
    'Initial SEO Audit',
    'Keyword Research',
    'Strategy Development',
    'Implementation',
    'Monitoring & Optimization',
    'Reporting & Analysis'
  ]

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-green-600 to-blue-700 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
          <div className="flex items-center gap-4 mb-6">
            <Link
              href="/services"
              className="flex items-center gap-2 text-green-100 hover:text-white transition-colors"
            >
              <ArrowLeftIcon className="h-5 w-5" />
              Back to Services
            </Link>
          </div>
          
          <div className="text-center max-w-4xl mx-auto">
            <div className="flex justify-center mb-6">
              <div className="p-4 bg-white/10 rounded-2xl backdrop-blur-sm">
                <MagnifyingGlassIcon className="h-12 w-12 text-white" />
              </div>
            </div>
            
            <h1 className="text-4xl md:text-6xl font-bold mb-6">
              Leading SEO Agency
            </h1>
            <p className="text-xl md:text-2xl text-green-100 mb-8 leading-relaxed">
              Be on every customer's radar with our Search Engine Optimization services.
            </p>
            <p className="text-lg text-green-100 mb-8">
              Our SEO agency is equipped with the skills to handle all aspects of search optimization 
              from keyword research to link building. This ensures an increase in your website traffic 
              which helps your website to rank higher among search results, improves lead generation and hence sales.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <button
                onClick={handleAddToCart}
                className="bg-white text-green-600 px-8 py-4 rounded-lg font-semibold hover:bg-green-50 transition-colors"
              >
                Start SEO Campaign - $800/month
              </button>
              <Link
                href="/contact"
                className="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-green-600 transition-colors"
              >
                Chat with a Specialist
              </Link>
            </div>
            
            <div className="mt-8 text-green-100">
              <p className="text-lg font-semibold">Rank No.1 On Google</p>
            </div>
          </div>
        </div>
      </div>

      {/* Main Services Overview */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Our Offerings
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Boost online visibility with our SEO services: keyword research, 
            on-page optimization, link building, and analytics to drive organic traffic.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {mainServices.map((service, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow text-center"
            >
              <div className="p-3 bg-green-100 rounded-lg w-fit mx-auto mb-4">
                <service.icon className="h-8 w-8 text-green-600" />
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">
                {service.title}
              </h3>
              <p className="text-gray-600">
                {service.description}
              </p>
            </motion.div>
          ))}
        </div>
      </div>

      {/* Why Choose Nuwair Systems */}
      <div className="bg-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                SEO Agency Services
              </h2>
              <p className="text-lg text-gray-600 mb-8">
                We are a specialist SEO consultancy with an experienced team of SEO consultants 
                who work with you to ensure your digital marketing is fully tailored to your goals 
                and expectations. Within just a few months we can improve your website performance 
                and site score by over 100%.
              </p>
              
              <div className="grid grid-cols-2 gap-3">
                {features.map((feature, index) => (
                  <div key={index} className="flex items-center gap-2">
                    <div className="w-2 h-2 bg-green-500 rounded-full flex-shrink-0"></div>
                    <span className="text-gray-700 text-sm">{feature}</span>
                  </div>
                ))}
              </div>
            </div>
            
            <div className="bg-gradient-to-br from-green-50 to-blue-50 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-gray-900 mb-6">SEO Performance Metrics</h3>
              
              <div className="space-y-4">
                <div className="bg-white p-4 rounded-lg shadow-sm">
                  <div className="flex justify-between items-center">
                    <span className="text-gray-600">Website Performance Improvement</span>
                    <span className="font-bold text-green-600">100%+</span>
                  </div>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm">
                  <div className="flex justify-between items-center">
                    <span className="text-gray-600">Signals Monitored</span>
                    <span className="font-bold text-blue-600">200+</span>
                  </div>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm">
                  <div className="flex justify-between items-center">
                    <span className="text-gray-600">Results Timeline</span>
                    <span className="font-bold text-purple-600">3 months</span>
                  </div>
                </div>
              </div>
              
              <div className="mt-6 p-6 bg-white rounded-xl shadow-sm">
                <h4 className="font-semibold text-gray-900 mb-4">Package Details:</h4>
                <div className="space-y-2">
                  <div className="flex justify-between">
                    <span className="text-gray-600">Starting Price</span>
                    <span className="font-bold text-green-600">$800/month</span>
                  </div>
                  <div className="flex justify-between">
                    <span className="text-gray-600">Reporting</span>
                    <span className="font-medium">Weekly & Monthly</span>
                  </div>
                  <div className="flex justify-between">
                    <span className="text-gray-600">Keywords</span>
                    <span className="font-medium">Unlimited Focus</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Services */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Comprehensive SEO Services
          </h2>
          <p className="text-xl text-gray-600">
            Everything you need to dominate search engine results
          </p>
        </div>

        <div className="space-y-16">
          {detailedServices.map((service, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className={`grid grid-cols-1 lg:grid-cols-2 gap-12 items-center ${
                index % 2 === 1 ? 'lg:grid-flow-col-dense' : ''
              }`}
            >
              <div className={index % 2 === 1 ? 'lg:col-start-2' : ''}>
                <div className="flex items-center gap-4 mb-4">
                  <div className="p-3 bg-green-100 rounded-lg">
                    <service.icon className="h-8 w-8 text-green-600" />
                  </div>
                  <h3 className="text-2xl font-bold text-gray-900">{service.title}</h3>
                </div>
                <p className="text-lg text-gray-600 mb-4">{service.description}</p>
                <p className="text-gray-600">{service.details}</p>
              </div>
              
              <div className={`bg-gradient-to-br ${
                index % 2 === 0 
                  ? 'from-green-50 to-blue-50' 
                  : 'from-blue-50 to-purple-50'
              } rounded-2xl p-8 ${index % 2 === 1 ? 'lg:col-start-1' : ''}`}>
                <div className="text-center">
                  <service.icon className={`h-16 w-16 mx-auto mb-4 ${
                    index % 2 === 0 ? 'text-green-600' : 'text-blue-600'
                  }`} />
                  <div className="space-y-3">
                    {index === 0 && (
                      <>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Technical Analysis</div>
                          <div className="text-sm text-gray-600">Complete site structure review</div>
                        </div>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Performance Optimization</div>
                          <div className="text-sm text-gray-600">Speed and indexing improvements</div>
                        </div>
                      </>
                    )}
                    {index === 1 && (
                      <>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Keyword Research</div>
                          <div className="text-sm text-gray-600">Strategic keyword identification</div>
                        </div>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Content Optimization</div>
                          <div className="text-sm text-gray-600">Engaging, SEO-friendly content</div>
                        </div>
                      </>
                    )}
                    {index === 2 && (
                      <>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Quality Backlinks</div>
                          <div className="text-sm text-gray-600">High-authority link acquisition</div>
                        </div>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Strategic Outreach</div>
                          <div className="text-sm text-gray-600">Targeted link building campaigns</div>
                        </div>
                      </>
                    )}
                    {index > 2 && (
                      <div className="bg-white p-4 rounded-lg shadow-sm">
                        <div className="font-medium text-gray-900">Expert Implementation</div>
                        <div className="text-sm text-gray-600">Professional execution and monitoring</div>
                      </div>
                    )}
                  </div>
                </div>
              </div>
            </motion.div>
          ))}
        </div>
      </div>

      {/* Process */}
      <div className="bg-gray-100 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Our SEO Process
            </h2>
            <p className="text-xl text-gray-600">
              A systematic approach to search engine optimization success
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-6">
            {process.map((step, index) => (
              <div key={index} className="text-center">
                <div className="w-16 h-16 bg-green-600 text-white rounded-full flex items-center justify-center font-bold text-xl mx-auto mb-4">
                  {index + 1}
                </div>
                <h3 className="font-semibold text-gray-900 mb-2">{step}</h3>
                <div className="text-sm text-gray-600">
                  {index === 0 && "Comprehensive website analysis"}
                  {index === 1 && "Strategic keyword identification"}
                  {index === 2 && "Custom SEO strategy development"}
                  {index === 3 && "Technical and content optimization"}
                  {index === 4 && "Continuous performance tracking"}
                  {index === 5 && "Monthly results and insights"}
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* FAQ Section */}
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">
            Frequently Asked Questions
          </h2>
          <p className="text-xl text-gray-600">
            Got a question? We've got you covered!
          </p>
        </div>

        <div className="space-y-6">
          {faqs.map((faq, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className="bg-white rounded-xl shadow-lg p-6"
            >
              <h3 className="text-lg font-semibold text-gray-900 mb-3">
                {faq.question}
              </h3>
              <p className="text-gray-600">
                {faq.answer}
              </p>
            </motion.div>
          ))}
        </div>
      </div>

      {/* CTA Section */}
      <div className="bg-gradient-to-r from-green-600 to-blue-600 text-white py-16">
        <div className="max-w-4xl mx-auto text-center px-4 sm:px-6 lg:px-8">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Ready to Dominate Search Results?
          </h2>
          <p className="text-xl text-green-100 mb-8">
            Let Nuwair Systems boost your search engine rankings and drive qualified organic traffic to your website.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button
              onClick={handleAddToCart}
              className="bg-white text-green-600 px-8 py-4 rounded-lg font-semibold hover:bg-green-50 transition-colors"
            >
              Start SEO Campaign - $800/month
            </button>
            <Link
              href="/contact"
              className="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-green-600 transition-colors"
            >
              Get Free SEO Audit
            </Link>
          </div>
          
          <div className="mt-8 flex items-center justify-center gap-8 text-green-100">
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>White-Hat Techniques</span>
            </div>
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>Proven Results</span>
            </div>
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>Expert Team</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}