'use client'

import { useState } from 'react'
import Link from 'next/link'
import { motion } from 'framer-motion'
import { 
  CheckCircleIcon, 
  ClockIcon, 
  CurrencyDollarIcon,
  ArrowLeftIcon,
  MegaphoneIcon,
  UserGroupIcon,
  ChatBubbleLeftRightIcon,
  ChartBarIcon,
  EyeIcon,
  PencilIcon,
  CalendarIcon,
  HeartIcon,
  SpeakerWaveIcon,
  StarIcon
} from '@heroicons/react/24/outline'
import { useCartStore } from '@/store/cart'

export default function SocialMediaMarketingPage() {
  const addToCart = useCartStore((state) => state.addToCart)
  const openCart = useCartStore((state) => state.openCart)

  const handleAddToCart = () => {
    addToCart({
      id: 4,
      title: 'Social Media Marketing',
      price: 1200,
      quantity: 1
    })
    
    setTimeout(() => {
      openCart()
    }, 100)
  }

  const services = [
    {
      icon: PencilIcon,
      title: 'Content Development & Strategy',
      description: 'Create compelling content and devise effective strategies to engage your audience, build brand credibility, and drive results on social media platforms.'
    },
    {
      icon: ChartBarIcon,
      title: 'Campaign Management',
      description: 'Our team manages and optimizes social media campaigns, leveraging data-driven insights to maximize reach, engagement, and conversions for your brand.'
    },
    {
      icon: UserGroupIcon,
      title: 'Community Management',
      description: 'We build and nurture an engaged community around your brand, fostering meaningful interactions and brand advocacy on social media platforms.'
    },
    {
      icon: StarIcon,
      title: 'Influencer Marketing',
      description: 'Leverage the power of influencers to expand your reach, increase brand visibility, and drive engagement on all your social media channels.'
    },
    {
      icon: CalendarIcon,
      title: 'Content Calendar & Scheduling',
      description: 'Strategic planning and scheduling of social media posts to ensure consistent and timely delivery with cohesive brand voice.'
    },
    {
      icon: EyeIcon,
      title: 'Brand Awareness',
      description: 'Boost brand awareness through targeted social media strategies that resonate with your audience and increase visibility.'
    },
    {
      icon: ChatBubbleLeftRightIcon,
      title: 'Social Media Listening',
      description: 'Monitor conversations and sentiment around your brand using advanced tools to gain valuable insights and improve customer experience.'
    },
    {
      icon: HeartIcon,
      title: 'Facebook & Instagram Marketing',
      description: 'Specialized marketing on Meta platforms with strategic ad campaigns, content creation, and community management for maximum ROI.'
    }
  ]

  const features = [
    'Full Funnel Implementation',
    'Fixed Fee Monthly Retainers',
    'Ongoing Management',
    'Proven Techniques',
    'Constant Campaign Monitoring',
    'Dedicated Project Management',
    'Bespoke Tailored Strategies',
    'Latest Strategies',
    'Marketing Automation',
    'Brand Awareness Building',
    'Monthly Reporting',
    'Constant Communication'
  ]

  const platforms = [
    { name: 'Facebook', color: 'bg-blue-600' },
    { name: 'Instagram', color: 'bg-pink-600' },
    { name: 'Twitter', color: 'bg-sky-500' },
    { name: 'LinkedIn', color: 'bg-blue-700' },
    { name: 'TikTok', color: 'bg-black' },
    { name: 'YouTube', color: 'bg-red-600' }
  ]

  const process = [
    'Research & Analysis',
    'Strategy Development',
    'Content Creation',
    'Campaign Launch',
    'Community Engagement',
    'Performance Monitoring'
  ]

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-blue-600 to-purple-700 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
          <div className="flex items-center gap-4 mb-6">
            <Link
              href="/services"
              className="flex items-center gap-2 text-blue-100 hover:text-white transition-colors"
            >
              <ArrowLeftIcon className="h-5 w-5" />
              Back to Services
            </Link>
          </div>
          
          <div className="text-center max-w-4xl mx-auto">
            <div className="flex justify-center mb-6">
              <div className="p-4 bg-white/10 rounded-2xl backdrop-blur-sm">
                <MegaphoneIcon className="h-12 w-12 text-white" />
              </div>
            </div>
            
            <h1 className="text-4xl md:text-6xl font-bold mb-6">
              Social Media Marketing Agency
            </h1>
            <p className="text-xl md:text-2xl text-blue-100 mb-8 leading-relaxed">
              We offer fully-managed social media services, designed specifically for your business growth and success.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <button
                onClick={handleAddToCart}
                className="bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold hover:bg-blue-50 transition-colors"
              >
                Get Started - $1,200/month
              </button>
              <Link
                href="/contact"
                className="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-blue-600 transition-colors"
              >
                Chat with a Specialist
              </Link>
            </div>
          </div>
        </div>
      </div>

      {/* Main Services */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Our Comprehensive Offerings
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            We offer comprehensive social media services including content development, 
            influencer marketing, and community management for maximum impact.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {services.map((service, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow"
            >
              <div className="p-3 bg-blue-100 rounded-lg w-fit mb-4">
                <service.icon className="h-6 w-6 text-blue-600" />
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">
                {service.title}
              </h3>
              <p className="text-gray-600">
                {service.description}
              </p>
            </motion.div>
          ))}
        </div>
      </div>

      {/* Why Choose Nuwair Systems */}
      <div className="bg-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                Leading Social Media Marketing Agency
              </h2>
              <p className="text-lg text-gray-600 mb-8">
                We're a trustworthy and renowned social media marketing agency with extensive 
                experience in the field. Our team of dedicated professionals helps visionary 
                business owners develop strategic and individualized marketing strategies to 
                enable them to achieve their goals.
              </p>
              
              <div className="grid grid-cols-2 gap-4">
                {features.map((feature, index) => (
                  <div key={index} className="flex items-center gap-2">
                    <CheckCircleIcon className="h-5 w-5 text-green-500 flex-shrink-0" />
                    <span className="text-gray-700 text-sm">{feature}</span>
                  </div>
                ))}
              </div>
            </div>
            
            <div className="bg-gradient-to-br from-blue-50 to-purple-50 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-gray-900 mb-6">Platforms We Master</h3>
              <div className="grid grid-cols-2 gap-4">
                {platforms.map((platform, index) => (
                  <div
                    key={index}
                    className={`${platform.color} text-white p-4 rounded-lg text-center font-semibold`}
                  >
                    {platform.name}
                  </div>
                ))}
              </div>
              
              <div className="mt-8 p-6 bg-white rounded-xl shadow-sm">
                <h4 className="font-semibold text-gray-900 mb-4">What You Get:</h4>
                <div className="space-y-2">
                  <div className="flex justify-between">
                    <span className="text-gray-600">Starting Price</span>
                    <span className="font-bold text-green-600">$1,200/month</span>
                  </div>
                  <div className="flex justify-between">
                    <span className="text-gray-600">Contract Length</span>
                    <span className="font-medium">3-12 months</span>
                  </div>
                  <div className="flex justify-between">
                    <span className="text-gray-600">Setup Period</span>
                    <span className="font-medium">Included</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Services */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="space-y-16">
          {/* Content Calendar */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Content Calendar & Scheduling
              </h2>
              <p className="text-lg text-gray-600 mb-6">
                Our content and copywriting team excels at creating content calendars and 
                scheduling social media posts strategically. By planning and organizing content 
                in advance, we ensure consistent and timely delivery.
              </p>
              <p className="text-gray-600">
                This approach allows us to maintain a cohesive brand voice, engage with your 
                audience consistently, and maximize the impact of your social media marketing 
                efforts. Trust us to handle your content calendar and scheduling, so you can 
                focus on other aspects of your business.
              </p>
            </div>
            <div className="bg-gradient-to-br from-blue-50 to-indigo-100 rounded-2xl p-8">
              <CalendarIcon className="h-16 w-16 text-blue-600 mb-4" />
              <div className="space-y-3">
                <div className="bg-white p-3 rounded-lg shadow-sm">
                  <div className="font-medium text-gray-900">Weekly Content Planning</div>
                  <div className="text-sm text-gray-600">Strategic content mapped to goals</div>
                </div>
                <div className="bg-white p-3 rounded-lg shadow-sm">
                  <div className="font-medium text-gray-900">Optimal Timing</div>
                  <div className="text-sm text-gray-600">Posts scheduled for maximum engagement</div>
                </div>
                <div className="bg-white p-3 rounded-lg shadow-sm">
                  <div className="font-medium text-gray-900">Brand Consistency</div>
                  <div className="text-sm text-gray-600">Cohesive voice across all platforms</div>
                </div>
              </div>
            </div>
          </div>

          {/* Brand Awareness */}
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div className="order-2 lg:order-1 bg-gradient-to-br from-purple-50 to-pink-100 rounded-2xl p-8">
              <EyeIcon className="h-16 w-16 text-purple-600 mb-4" />
              <div className="space-y-3">
                <div className="bg-white p-3 rounded-lg shadow-sm">
                  <div className="font-medium text-gray-900">Targeted Strategies</div>
                  <div className="text-sm text-gray-600">Audience-specific campaigns</div>
                </div>
                <div className="bg-white p-3 rounded-lg shadow-sm">
                  <div className="font-medium text-gray-900">Compelling Content</div>
                  <div className="text-sm text-gray-600">Content that resonates and engages</div>
                </div>
                <div className="bg-white p-3 rounded-lg shadow-sm">
                  <div className="font-medium text-gray-900">Brand Recognition</div>
                  <div className="text-sm text-gray-600">Increased visibility and trust</div>
                </div>
              </div>
            </div>
            <div className="order-1 lg:order-2">
              <h2 className="text-3xl font-bold text-gray-900 mb-4">
                Brand Awareness
              </h2>
              <p className="text-lg text-gray-600 mb-6">
                Nuwair Systems specializes in boosting brand awareness through targeted social 
                media strategies. By understanding your target audience and industry, we create 
                compelling content that resonates with your audience, increasing your brand's 
                visibility and recognition.
              </p>
              <p className="text-gray-600">
                Through strategic campaigns and consistent engagement, we cultivate a strong 
                brand presence, fostering trust and loyalty among your customers. Trust us to 
                elevate your brand awareness and drive meaningful connections with your audience.
              </p>
            </div>
          </div>
        </div>
      </div>

      {/* Process */}
      <div className="bg-gray-100 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Our Social Media Marketing Process
            </h2>
            <p className="text-xl text-gray-600">
              A proven methodology that delivers consistent results
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-6">
            {process.map((step, index) => (
              <div key={index} className="text-center">
                <div className="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-xl mx-auto mb-4">
                  {index + 1}
                </div>
                <h3 className="font-semibold text-gray-900 mb-2">{step}</h3>
                <div className="text-sm text-gray-600">
                  {index === 0 && "Deep dive research and competitor analysis"}
                  {index === 1 && "Custom strategy tailored to your goals"}
                  {index === 2 && "Compelling content that engages"}
                  {index === 3 && "Strategic campaign deployment"}
                  {index === 4 && "Building meaningful connections"}
                  {index === 5 && "Data-driven optimization"}
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* CTA Section */}
      <div className="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-16">
        <div className="max-w-4xl mx-auto text-center px-4 sm:px-6 lg:px-8">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Ready to Transform Your Social Media Presence?
          </h2>
          <p className="text-xl text-blue-100 mb-8">
            Let Nuwair Systems help you build a thriving online community and drive meaningful results.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button
              onClick={handleAddToCart}
              className="bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold hover:bg-blue-50 transition-colors"
            >
              Start Your Campaign - $1,200/month
            </button>
            <Link
              href="/contact"
              className="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-blue-600 transition-colors"
            >
              Schedule a Consultation
            </Link>
          </div>
          
          <div className="mt-8 flex items-center justify-center gap-8 text-blue-100">
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>Fixed Monthly Fees</span>
            </div>
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>30-Day Notice</span>
            </div>
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>Proven Results</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}