'use client'

import { useState } from 'react'
import Link from 'next/link'
import { motion } from 'framer-motion'
import { 
  CheckCircleIcon, 
  ClockIcon, 
  CurrencyDollarIcon,
  ArrowLeftIcon,
  CodeBracketIcon,
  ComputerDesktopIcon,
  PaintBrushIcon,
  ShoppingBagIcon,
  CogIcon,
  ServerIcon,
  RocketLaunchIcon,
  DocumentTextIcon,
  ShieldCheckIcon,
  ChatBubbleLeftRightIcon,
  GlobeAltIcon,
  DevicePhoneMobileIcon,
  MagnifyingGlassIcon,
  ArrowTrendingUpIcon,
  UserGroupIcon,
  WrenchScrewdriverIcon
} from '@heroicons/react/24/outline'
import { useCartStore } from '@/store/cart'

export default function WebsiteDevelopmentPage() {
  const addToCart = useCartStore((state) => state.addToCart)
  const openCart = useCartStore((state) => state.openCart)

  const handleAddToCart = () => {
    addToCart({
      id: 1,
      title: 'Website Development',
      price: 2500,
      quantity: 1
    })
    
    setTimeout(() => {
      openCart()
    }, 100)
  }

  const mainServices = [
    {
      icon: ComputerDesktopIcon,
      title: 'Front-End Development',
      description: 'We use various programming languages and frameworks to craft visually appealing and interactive interfaces that enhance user experience and drive engagement.'
    },
    {
      icon: PaintBrushIcon,
      title: 'UI & UX Design',
      description: 'Our focus is on creating visually stunning and user-friendly websites. Through thoughtful UI and UX design, we ensure an intuitive and engaging user experience.'
    },
    {
      icon: ShoppingBagIcon,
      title: 'E-Commerce Solutions',
      description: 'Our e-commerce solutions empower businesses to create robust online stores, enabling seamless transactions with secure payment gateways and efficient inventory management.'
    },
    {
      icon: WrenchScrewdriverIcon,
      title: 'Website Maintenance & Support',
      description: 'Providing reliable website technical support to ensure your website is up-to-date, protected against vulnerabilities, and performs optimally.'
    }
  ]

  const features = [
    'Free Discovery Call',
    'Dedicated Project Management',
    'Completely Bespoke Design',
    'Website Wireframing & Concepts',
    'Unlimited Page Options',
    'Unlimited Page Layouts',
    'Free Web Hosting (Or Transfer)',
    'Search Engine Optimization',
    'GDPR Ready',
    'Website Training On Completion',
    'Ongoing Monthly Support',
    'Weekly Project Updates'
  ]

  const detailedServices = [
    {
      icon: GlobeAltIcon,
      title: 'Complete Web Design & Development Services',
      description: 'Our team provides comprehensive web design and development services, ensuring a seamless online presence. We leverage cutting-edge technologies and industry best practices.',
      details: 'By understanding your business objectives, we tailor our services to meet your unique needs, delivering websites that captivate users, drive results, and elevate your brand\'s online presence. Trust us to create a website that represents your business with excellence and converts visitors into customers.'
    },
    {
      icon: ShoppingBagIcon,
      title: 'E-Commerce Website Design & Development',
      description: 'We specialize in designing and developing high-performance e-commerce websites using platforms like Shopify, WordPress, and WooCommerce.',
      details: 'Our team also provides seamless ERP integrations and API access, enabling efficient inventory management, order processing, and secure payment gateways. Trust us to build an e-commerce website that showcases your products, drives sales, and delivers a seamless shopping experience.'
    },
    {
      icon: ServerIcon,
      title: 'Backend Development',
      description: 'Our tech team excels in backend development, ensuring robust and scalable website functionality using cutting-edge technologies and industry best practices.',
      details: 'With a focus on reliability and seamless integration, we lay a strong foundation for your website\'s success. Trust us to handle complex backend development, allowing you to deliver a seamless user experience and achieve your business goals.'
    },
    {
      icon: UserGroupIcon,
      title: 'E-Commerce Marketplace',
      description: 'Our engineering team specializes in building robust e-commerce marketplaces, providing a platform for sellers and buyers to connect and transact.',
      details: 'With advanced features, secure payment gateways, and seamless user experience, we create scalable and customizable marketplace solutions. Trust us to empower your business with a versatile and thriving e-commerce ecosystem.'
    },
    {
      icon: RocketLaunchIcon,
      title: 'Performance Optimization',
      description: 'We prioritize performance optimization to ensure your website delivers a seamless and fast user experience through thorough audits and strategic optimizations.',
      details: 'By improving load times and user interactions, we create a positive impression, increase user engagement, and boost conversion rates. Trust us to optimize your website\'s performance for maximum satisfaction and business success.'
    },
    {
      icon: DocumentTextIcon,
      title: 'Content Management Systems',
      description: 'Our team specializes in implementing powerful Content Management Systems (CMS) to streamline website management using platforms like WordPress, Drupal, and Joomla.',
      details: 'We create user-friendly interfaces that empower you to update and manage your website content effortlessly. With our expertise in CMS development, we ensure scalability, flexibility, and easy customization for a dynamic online presence.'
    }
  ]

  const technologies = [
    { name: 'React', category: 'Frontend' },
    { name: 'Next.js', category: 'Framework' },
    { name: 'Node.js', category: 'Backend' },
    { name: 'WordPress', category: 'CMS' },
    { name: 'Shopify', category: 'E-commerce' },
    { name: 'WooCommerce', category: 'E-commerce' },
    { name: 'MongoDB', category: 'Database' },
    { name: 'PostgreSQL', category: 'Database' }
  ]

  const faqs = [
    {
      question: 'How much does a website from Nuwair Systems cost?',
      answer: 'We develop marketing-focused websites for businesses that typically start at $2,500. More technical or complex websites can range from between $3,000 and $50,000. All prices exclude taxes.'
    },
    {
      question: 'Will my website be search engine optimized?',
      answer: 'Yes, every website we build has all of the basic foundations for Search Engine Optimization. These are designed to launch your website in a good position, however, an ongoing SEO strategy is highly recommended as part of your ongoing marketing efforts.'
    },
    {
      question: 'What factors influence the cost of a website?',
      answer: 'There are many variables that can increase the costs of developing a website but the three main factors are complexity of the website (number of pages, sitemap, UX designing), website content (who will create it) and technical requirements (plugins, functionality, e-commerce, etc.)'
    },
    {
      question: 'Do you design affordable websites for startups?',
      answer: 'We have created affordable websites for many startups and smaller businesses. These websites are designed to get you online and give you a platform to develop your business with essential features and professional design.'
    }
  ]

  const process = [
    'Discovery & Planning',
    'Design & Wireframing',
    'Development & Integration',
    'Testing & Optimization',
    'Launch & Deployment',
    'Support & Maintenance'
  ]

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <div className="bg-gradient-to-br from-blue-600 to-indigo-800 text-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
          <div className="flex items-center gap-4 mb-6">
            <Link
              href="/services"
              className="flex items-center gap-2 text-blue-100 hover:text-white transition-colors"
            >
              <ArrowLeftIcon className="h-5 w-5" />
              Back to Services
            </Link>
          </div>
          
          <div className="text-center max-w-4xl mx-auto">
            <div className="flex justify-center mb-6">
              <div className="p-4 bg-white/10 rounded-2xl backdrop-blur-sm">
                <CodeBracketIcon className="h-12 w-12 text-white" />
              </div>
            </div>
            
            <h1 className="text-4xl md:text-6xl font-bold mb-6">
              Web Design Agency
            </h1>
            <p className="text-xl md:text-2xl text-blue-100 mb-8 leading-relaxed">
              Web design & development services that meet industry-leading standards.
            </p>
            <p className="text-lg text-blue-100 mb-8">
              Our website development agency specializes in building e-commerce websites and CMS-based solutions. 
              With a focus on SEO optimization, we create high-performing websites that drive traffic, enhance user 
              experience, and maximize online visibility for your business.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <button
                onClick={handleAddToCart}
                className="bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold hover:bg-blue-50 transition-colors"
              >
                Start Project - From $2,500
              </button>
              <Link
                href="/contact"
                className="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-blue-600 transition-colors"
              >
                Chat with a Specialist
              </Link>
            </div>
            
            <div className="mt-8 text-blue-100">
              <p className="text-lg font-semibold">Websites Engineered for Growth</p>
            </div>
          </div>
        </div>
      </div>

      {/* Main Services Overview */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Our Offerings
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            We create stunning websites that captivate users, drive results, and elevate your online presence.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {mainServices.map((service, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className="bg-white rounded-xl shadow-lg p-6 hover:shadow-xl transition-shadow text-center"
            >
              <div className="p-3 bg-blue-100 rounded-lg w-fit mx-auto mb-4">
                <service.icon className="h-8 w-8 text-blue-600" />
              </div>
              <h3 className="text-xl font-semibold text-gray-900 mb-3">
                {service.title}
              </h3>
              <p className="text-gray-600">
                {service.description}
              </p>
            </motion.div>
          ))}
        </div>
      </div>

      {/* Why Choose Nuwair Systems */}
      <div className="bg-white py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                Website Development Company
              </h2>
              <h3 className="text-2xl font-semibold text-blue-600 mb-4">
                What Our Website Design Projects Include
              </h3>
              <p className="text-lg text-gray-600 mb-8">
                Our comprehensive website development services encompass strategic planning, design, development, 
                content creation, functionality integration, testing, optimization, and ongoing maintenance to 
                deliver a seamless user experience and achieve your online objectives.
              </p>
              
              <div className="grid grid-cols-2 gap-3">
                {features.map((feature, index) => (
                  <div key={index} className="flex items-center gap-2">
                    <div className="w-2 h-2 bg-blue-500 rounded-full flex-shrink-0"></div>
                    <span className="text-gray-700 text-sm">{feature}</span>
                  </div>
                ))}
              </div>
            </div>
            
            <div className="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-2xl p-8">
              <h3 className="text-2xl font-bold text-gray-900 mb-6">Performance Results</h3>
              
              <div className="space-y-4">
                <div className="bg-white p-4 rounded-lg shadow-sm">
                  <div className="flex justify-between items-center">
                    <span className="text-gray-600">Site Score Improvement</span>
                    <span className="font-bold text-blue-600">30%+</span>
                  </div>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm">
                  <div className="flex justify-between items-center">
                    <span className="text-gray-600">Search Rankings</span>
                    <span className="font-bold text-green-600">Enhanced</span>
                  </div>
                </div>
                <div className="bg-white p-4 rounded-lg shadow-sm">
                  <div className="flex justify-between items-center">
                    <span className="text-gray-600">User Engagement</span>
                    <span className="font-bold text-purple-600">Improved</span>
                  </div>
                </div>
              </div>

              <div className="mt-6">
                <h4 className="font-semibold text-gray-900 mb-4">Technologies We Use:</h4>
                <div className="grid grid-cols-2 gap-2">
                  {technologies.map((tech, index) => (
                    <div key={index} className="bg-white p-2 rounded-lg shadow-sm text-center">
                      <div className="font-medium text-gray-900 text-sm">{tech.name}</div>
                      <div className="text-xs text-gray-600">{tech.category}</div>
                    </div>
                  ))}
                </div>
              </div>
              
              <div className="mt-6 p-6 bg-white rounded-xl shadow-sm">
                <h4 className="font-semibold text-gray-900 mb-4">Package Details:</h4>
                <div className="space-y-2">
                  <div className="flex justify-between">
                    <span className="text-gray-600">Starting Price</span>
                    <span className="font-bold text-blue-600">$2,500</span>
                  </div>
                  <div className="flex justify-between">
                    <span className="text-gray-600">Timeline</span>
                    <span className="font-medium">3-6 weeks</span>
                  </div>
                  <div className="flex justify-between">
                    <span className="text-gray-600">Support</span>
                    <span className="font-medium">1 Year Included</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Detailed Services */}
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Comprehensive Web Development Services
          </h2>
          <p className="text-xl text-gray-600">
            Everything you need for a successful online presence
          </p>
        </div>

        <div className="space-y-16">
          {detailedServices.map((service, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className={`grid grid-cols-1 lg:grid-cols-2 gap-12 items-center ${
                index % 2 === 1 ? 'lg:grid-flow-col-dense' : ''
              }`}
            >
              <div className={index % 2 === 1 ? 'lg:col-start-2' : ''}>
                <div className="flex items-center gap-4 mb-4">
                  <div className="p-3 bg-blue-100 rounded-lg">
                    <service.icon className="h-8 w-8 text-blue-600" />
                  </div>
                  <h3 className="text-2xl font-bold text-gray-900">{service.title}</h3>
                </div>
                <p className="text-lg text-gray-600 mb-4">{service.description}</p>
                <p className="text-gray-600">{service.details}</p>
              </div>
              
              <div className={`bg-gradient-to-br ${
                index % 2 === 0 
                  ? 'from-blue-50 to-indigo-50' 
                  : 'from-indigo-50 to-purple-50'
              } rounded-2xl p-8 ${index % 2 === 1 ? 'lg:col-start-1' : ''}`}>
                <div className="text-center">
                  <service.icon className={`h-16 w-16 mx-auto mb-4 ${
                    index % 2 === 0 ? 'text-blue-600' : 'text-indigo-600'
                  }`} />
                  <div className="space-y-3">
                    {index === 0 && (
                      <>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Custom Solutions</div>
                          <div className="text-sm text-gray-600">Tailored to your business needs</div>
                        </div>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Modern Technologies</div>
                          <div className="text-sm text-gray-600">Cutting-edge development stack</div>
                        </div>
                      </>
                    )}
                    {index === 1 && (
                      <>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Multi-Platform</div>
                          <div className="text-sm text-gray-600">Shopify, WordPress, WooCommerce</div>
                        </div>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Payment Integration</div>
                          <div className="text-sm text-gray-600">Secure payment gateways</div>
                        </div>
                      </>
                    )}
                    {index === 2 && (
                      <>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">Scalable Architecture</div>
                          <div className="text-sm text-gray-600">Built for growth and performance</div>
                        </div>
                        <div className="bg-white p-3 rounded-lg shadow-sm">
                          <div className="font-medium text-gray-900">API Integration</div>
                          <div className="text-sm text-gray-600">Seamless third-party connections</div>
                        </div>
                      </>
                    )}
                    {index > 2 && (
                      <div className="bg-white p-4 rounded-lg shadow-sm">
                        <div className="font-medium text-gray-900">Expert Implementation</div>
                        <div className="text-sm text-gray-600">Professional development and deployment</div>
                      </div>
                    )}
                  </div>
                </div>
              </div>
            </motion.div>
          ))}
        </div>
      </div>

      {/* Process */}
      <div className="bg-gray-100 py-16">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-gray-900 mb-4">
              Our Development Process
            </h2>
            <p className="text-xl text-gray-600">
              A systematic approach to delivering exceptional websites
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-6">
            {process.map((step, index) => (
              <div key={index} className="text-center">
                <div className="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-xl mx-auto mb-4">
                  {index + 1}
                </div>
                <h3 className="font-semibold text-gray-900 mb-2">{step}</h3>
                <div className="text-sm text-gray-600">
                  {index === 0 && "Understanding your goals and requirements"}
                  {index === 1 && "Creating wireframes and visual concepts"}
                  {index === 2 && "Building with modern technologies"}
                  {index === 3 && "Quality assurance and performance tuning"}
                  {index === 4 && "Going live with full deployment"}
                  {index === 5 && "Ongoing support and maintenance"}
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>

      {/* FAQ Section */}
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold text-gray-900 mb-4">
            Frequently Asked Questions
          </h2>
          <p className="text-xl text-gray-600">
            Got a question? We've got you covered!
          </p>
        </div>

        <div className="space-y-6">
          {faqs.map((faq, index) => (
            <motion.div
              key={index}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: index * 0.1 }}
              className="bg-white rounded-xl shadow-lg p-6"
            >
              <h3 className="text-lg font-semibold text-gray-900 mb-3">
                {faq.question}
              </h3>
              <p className="text-gray-600">
                {faq.answer}
              </p>
            </motion.div>
          ))}
        </div>
      </div>

      {/* CTA Section */}
      <div className="bg-gradient-to-r from-blue-600 to-indigo-600 text-white py-16">
        <div className="max-w-4xl mx-auto text-center px-4 sm:px-6 lg:px-8">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Ready to Transform Your Online Presence?
          </h2>
          <p className="text-xl text-blue-100 mb-8">
            Let Nuwair Systems create a website that drives results and grows your business.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button
              onClick={handleAddToCart}
              className="bg-white text-blue-600 px-8 py-4 rounded-lg font-semibold hover:bg-blue-50 transition-colors"
            >
              Start Your Project - From $2,500
            </button>
            <Link
              href="/contact"
              className="border-2 border-white text-white px-8 py-4 rounded-lg font-semibold hover:bg-white hover:text-blue-600 transition-colors"
            >
              Get Free Consultation
            </Link>
          </div>
          
          <div className="mt-8 flex items-center justify-center gap-8 text-blue-100">
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>Industry Standards</span>
            </div>
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>SEO Optimized</span>
            </div>
            <div className="flex items-center gap-2">
              <CheckCircleIcon className="h-5 w-5" />
              <span>Mobile Responsive</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}