'use client'

import { motion } from 'framer-motion'
import { 
  CheckIcon, 
  ServerIcon, 
  ShieldCheckIcon, 
  BoltIcon,
  ClockIcon,
  CpuChipIcon
} from '@heroicons/react/24/outline'
import Link from 'next/link'

const plans = [
  {
    name: 'STARTUP',
    price: '$1.99',
    period: 'month',
    features: [
      '1 GB Storage',
      '10 GB Bandwidth/Traffic',
      '10 POP3 Mail User Accounts',
      '1 Domains Allowed',
      '1 FTP Accounts',
      '99.9% Service Uptime',
      '30 Day Money Back Guarantee'
    ],
    link: '/checkout?plan=shared-startup',
    popular: false
  },
  {
    name: 'BUSINESS',
    price: '$4.99',
    period: 'month',
    features: [
      '2 GB Storage',
      '5 GB Bandwidth/Traffic',
      '20 POP3 Mail User Accounts',
      '1 Domains Allowed',
      '1 FTP Accounts',
      '99.9% Service Uptime',
      '30 Day Money Back Guarantee'
    ],
    link: '/checkout?plan=shared-business',
    popular: true
  },
  {
    name: 'PREMIUM',
    price: '$7.99',
    period: 'month',
    features: [
      '5 GB Storage',
      '15 GB Bandwidth/Traffic',
      '40 POP3 Mail User Accounts',
      '1 Domains Allowed',
      '1 FTP Accounts',
      '99.9% Service Uptime',
      '30 Day Money Back Guarantee'
    ],
    link: '/checkout?plan=shared-premium',
    popular: false
  },
  {
    name: 'DEDICATED',
    price: '$11.99',
    period: 'month',
    features: [
      '15 GB Storage',
      '20 GB Bandwidth/Traffic',
      '100 POP3 Mail User Accounts',
      '1 Domains Allowed',
      '1 FTP Accounts',
      '99.9% Service Uptime',
      '30 Day Money Back Guarantee'
    ],
    link: '/checkout?plan=shared-dedicated',
    popular: false
  }
]

const features = [
  {
    title: 'Buy https Certificate',
    description: 'Free SSL certificates secure online data and are a cost-effective alternative to high SSL certificate price options.',
    icon: ShieldCheckIcon
  },
  {
    title: '24/7 Live Support',
    description: 'Our dedicated team of hosting in lahore is standing by, ready to help via email, chat and phone, we\'re here for all your Shared Hosting needs.',
    icon: ClockIcon
  },
  {
    title: 'Personalized Email Service',
    description: 'Buy email domain address of your choice to represent your business and help manage communication.',
    icon: CheckIcon
  },
  {
    title: 'Easy to Manage',
    description: 'A user-friendly control panel that allows you to easily perform common tasks such as creating email hosting and managing databases.',
    icon: CpuChipIcon
  },
  {
    title: 'Best Uptimes',
    description: 'We are best web service providers that able to consistently maintain uptime of 99.99% or higher are considered to be among the most reliable in the industry.',
    icon: BoltIcon
  },
  {
    title: 'Money Back Guarantee',
    description: 'We care our customer and need to serve you better, So you can get your money back for any purchase website domain made within the past 30 days',
    icon: ServerIcon
  }
]

export default function SharedHostingPage() {
  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <section className="relative py-20 bg-slate-900">
        <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAwIDEwIEwgMjAgMTAgTSAxMCAwIEwgMTAgMjAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjA1IiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-10"></div>
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
            className="text-center"
          >
            <motion.span
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: 0.2 }}
              className="inline-block px-4 py-2 rounded-full bg-blue-50 text-blue-600 text-sm font-semibold mb-4"
            >
              Enterprise Shared Hosting
            </motion.span>
            
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              Reliable Shared Hosting
            </h1>
            <p className="text-xl md:text-2xl text-slate-300 mb-2">
              Professional hosting solutions for businesses
            </p>
            <p className="text-lg text-slate-400 mb-8">
              Fully managed hosting with enterprise-grade performance
            </p>
            
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4 }}
            >
              <Link
                href="/shared-hosting#plans"
                className="inline-block px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-lg shadow-lg hover:bg-blue-700 transition-colors duration-200"
              >
                View Plans
              </Link>
            </motion.div>
          </motion.div>
        </div>
      </section>

      {/* Description Section */}
      <section className="py-16 bg-slate-50 border-y border-slate-200">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto">
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.6 }}
            >
              <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-6">Shared Hosting Solutions</h2>
              <p className="text-lg text-slate-600 leading-relaxed mb-4">
                Managed shared hosting is a professional hosting solution where our team manages the hosting environment for you. This includes server maintenance, security updates, and comprehensive technical support.
              </p>
              <p className="text-lg text-slate-600 leading-relaxed">
                Ideal for small to medium-sized businesses seeking cost-effective hosting without the complexity of server management.
              </p>
            </motion.div>
          </div>
        </div>
      </section>

      {/* Pricing Plans */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <div className="inline-flex items-center px-4 py-2 bg-blue-50 text-blue-600 rounded-full text-sm font-semibold mb-4">
              Hosting Plans
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-4">
              Choose Your Plan
            </h2>
            <p className="text-lg text-slate-600">Professional hosting solutions for every business need</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {plans.map((plan, index) => (
              <motion.div
                key={plan.name}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className={`relative bg-white rounded-xl border-2 overflow-hidden ${
                  plan.popular ? 'border-blue-600 shadow-lg' : 'border-slate-200'
                }`}
              >
                {plan.popular && (
                  <div className="absolute top-0 right-0 bg-blue-600 text-white px-4 py-1 text-sm font-semibold rounded-bl-lg">
                    POPULAR
                  </div>
                )}
                
                <div className="p-6">
                  <h3 className="text-2xl font-bold text-slate-900 mb-4">{plan.name}</h3>
                  <div className="mb-6">
                    <span className="text-4xl font-bold text-slate-900">{plan.price}</span>
                    <span className="text-slate-600"> / {plan.period}</span>
                  </div>
                  
                  <ul className="space-y-3 mb-8">
                    {plan.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start gap-2 text-slate-700">
                        <CheckIcon className="w-5 h-5 text-blue-600 flex-shrink-0 mt-0.5" />
                        <span className="text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                  
                  <Link
                    href={plan.link}
                    className="block w-full py-3 bg-blue-600 text-white text-center font-semibold rounded-lg hover:bg-blue-700 transition-colors duration-200"
                  >
                    Order Now
                  </Link>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="py-16 bg-slate-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <div className="inline-flex items-center px-4 py-2 bg-blue-50 text-blue-600 rounded-full text-sm font-semibold mb-4">
              Features
            </div>
            <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-4">
              Enterprise Features Included
            </h2>
            <p className="text-lg text-slate-600">Professional hosting with comprehensive support</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {features.map((feature, index) => {
              const Icon = feature.icon
              return (
                <motion.div
                  key={feature.title}
                  initial={{ opacity: 0, y: 20 }}
                  whileInView={{ opacity: 1, y: 0 }}
                  viewport={{ once: true }}
                  transition={{ delay: index * 0.1 }}
                  className="bg-white rounded-xl p-6 border border-slate-200 hover:shadow-md transition-shadow duration-200"
                >
                  <div className="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mb-4">
                    <Icon className="w-6 h-6 text-blue-600" />
                  </div>
                  <h3 className="text-xl font-bold text-slate-900 mb-3">{feature.title}</h3>
                  <p className="text-slate-600 leading-relaxed">{feature.description}</p>
                </motion.div>
              )
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-slate-900">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Ready to Get Started?
            </h2>
            <p className="text-xl text-slate-300 mb-8">
              Choose your hosting plan and launch your website today
            </p>
            <Link
              href="/shared-hosting#plans"
              className="inline-block px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-lg shadow-lg hover:bg-blue-700 transition-colors duration-200"
            >
              View All Plans
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
