import { Metadata } from 'next'
import { getServerSession } from 'next-auth'
import { redirect } from 'next/navigation'
import SubscriptionBilling from '@/components/SubscriptionBilling'

export const metadata: Metadata = {
  title: 'Subscriptions | NuwairSystems',
  description: 'Manage your subscriptions, billing, and recurring payments.',
}

export default async function SubscriptionsPage() {
  const session = await getServerSession()

  if (!session) {
    redirect('/auth/signin?callbackUrl=/subscriptions')
  }

  return <SubscriptionBilling />
}