'use client'

import { motion } from 'framer-motion'
import { 
  DocumentTextIcon, 
  ShieldCheckIcon, 
  ScaleIcon,
  CheckCircleIcon
} from '@heroicons/react/24/outline'
import Link from 'next/link'

export default function TermsOfService() {
  const sections = [
    {
      title: '1. Acceptance of Terms',
      content: 'By accessing and using Nuwair Systems\' services, you acknowledge that you have read, understood, and agree to be bound by these Terms of Service. If you do not agree with any part of these terms, you must not use our services.'
    },
    {
      title: '2. Service Description',
      content: 'Nuwair Systems provides web hosting, domain registration, VPS hosting, dedicated servers, cloud solutions, and related IT services. We reserve the right to modify, suspend, or discontinue any service at any time without prior notice.'
    },
    {
      title: '3. Account Registration',
      content: 'You must provide accurate, current, and complete information during registration. You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account. Notify us immediately of any unauthorized use.'
    },
    {
      title: '4. Payment Terms',
      content: 'All services must be paid for in advance unless otherwise agreed. Prices are subject to change with 30 days notice. Failure to pay may result in service suspension or termination. Refunds are provided according to our refund policy within the first 30 days for hosting services.'
    },
    {
      title: '5. Acceptable Use Policy',
      content: 'You agree not to use our services for any unlawful purpose, to transmit harmful code, engage in spamming, host illegal content, or violate intellectual property rights. We reserve the right to suspend accounts that violate our acceptable use policy.'
    },
    {
      title: '6. Service Level Agreement',
      content: 'We guarantee 99.9% uptime for our hosting services. Scheduled maintenance is excluded from this guarantee. Service credits may be available for downtime exceeding our SLA commitment, subject to verification and our credit policy.'
    },
    {
      title: '7. Data and Backups',
      content: 'While we perform regular backups, you are responsible for maintaining your own backups. We are not liable for data loss. We recommend maintaining independent backups of all critical data and applications.'
    },
    {
      title: '8. Intellectual Property',
      content: 'All content, trademarks, and intellectual property on our website and services remain the property of Nuwair Systems or their respective owners. You may not use our intellectual property without prior written consent.'
    },
    {
      title: '9. Limitation of Liability',
      content: 'Nuwair Systems shall not be liable for any indirect, incidental, special, consequential, or punitive damages. Our total liability is limited to the amount paid by you for services in the preceding 12 months.'
    },
    {
      title: '10. Termination',
      content: 'Either party may terminate services with 30 days written notice. We reserve the right to immediately terminate services for violation of these terms. Upon termination, you must cease using our services and delete any downloaded materials.'
    },
    {
      title: '11. Privacy and Data Protection',
      content: 'We are committed to protecting your privacy in accordance with applicable data protection laws including GDPR. Please review our Privacy Policy for detailed information about how we collect, use, and protect your data.'
    },
    {
      title: '12. Modifications to Terms',
      content: 'We reserve the right to modify these terms at any time. Changes will be effective immediately upon posting. Continued use of our services after changes constitutes acceptance of the modified terms. We will notify users of significant changes via email.'
    },
    {
      title: '13. Governing Law',
      content: 'These terms are governed by the laws of Pakistan. Any disputes will be resolved in the courts of Karachi, Pakistan. Both parties agree to submit to the exclusive jurisdiction of these courts.'
    },
    {
      title: '14. Contact Information',
      content: 'For questions about these Terms of Service, please contact us at legal@nuwair.com or call +92 3111 689 247. Our business hours are Monday to Friday, 9:00 AM to 6:00 PM PKT.'
    }
  ]

  return (
    <div className="min-h-screen bg-gradient-to-b from-slate-50 to-white">
      {/* Hero Section */}
      <section className="bg-slate-900 text-white py-20">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            className="text-center"
          >
            <div className="flex justify-center mb-6">
              <div className="rounded-full bg-blue-600/10 p-4">
                <DocumentTextIcon className="w-12 h-12 text-blue-400" />
              </div>
            </div>
            <h1 className="text-4xl md:text-5xl font-bold mb-6">
              Terms of Service
            </h1>
            <p className="text-xl text-slate-300 mb-4">
              Last Updated: November 13, 2025
            </p>
            <p className="text-lg text-slate-400 max-w-2xl mx-auto">
              Please read these terms carefully before using Nuwair Systems services. 
              By using our services, you agree to these terms and conditions.
            </p>
          </motion.div>
        </div>
      </section>

      {/* Quick Links */}
      <section className="py-8 bg-white border-b border-slate-200">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex flex-wrap gap-4 justify-center">
            <Link 
              href="/privacy"
              className="inline-flex items-center px-4 py-2 bg-slate-100 text-slate-700 rounded-lg hover:bg-slate-200 transition-colors"
            >
              <ShieldCheckIcon className="w-5 h-5 mr-2" />
              Privacy Policy
            </Link>
            <Link 
              href="/contact"
              className="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors"
            >
              Contact Legal Team
            </Link>
          </div>
        </div>
      </section>

      {/* Terms Content */}
      <section className="py-16">
        <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="space-y-8">
            {sections.map((section, index) => (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: index * 0.05 }}
                className="bg-white rounded-xl shadow-sm border border-slate-200 p-8 hover:shadow-md transition-shadow"
              >
                <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-start">
                  <CheckCircleIcon className="w-6 h-6 text-blue-600 mr-3 flex-shrink-0 mt-1" />
                  {section.title}
                </h2>
                <p className="text-slate-700 leading-relaxed">
                  {section.content}
                </p>
              </motion.div>
            ))}
          </div>

          {/* Important Notice */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.8 }}
            className="mt-12 bg-blue-50 border border-blue-200 rounded-xl p-8"
          >
            <div className="flex items-start">
              <ScaleIcon className="w-8 h-8 text-blue-600 mr-4 flex-shrink-0" />
              <div>
                <h3 className="text-xl font-bold text-slate-900 mb-3">
                  Important Legal Notice
                </h3>
                <p className="text-slate-700 leading-relaxed mb-4">
                  These Terms of Service constitute a legally binding agreement between you and Nuwair Systems. 
                  By using our services, you acknowledge that you have read, understood, and agree to be bound by these terms.
                </p>
                <p className="text-slate-700 leading-relaxed">
                  If you have any questions or concerns about these terms, please contact our legal team at 
                  <a href="mailto:legal@nuwair.com" className="text-blue-600 hover:text-blue-700 font-medium"> legal@nuwair.com</a> 
                  {' '}before using our services.
                </p>
              </div>
            </div>
          </motion.div>

          {/* Contact CTA */}
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.9 }}
            className="mt-12 text-center"
          >
            <Link
              href="/contact"
              className="inline-flex items-center px-8 py-4 bg-slate-900 text-white rounded-lg font-semibold hover:bg-slate-800 transition-colors shadow-lg hover:shadow-xl"
            >
              Have Questions? Contact Us
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
