'use client'

import { motion } from 'framer-motion'
import { CheckIcon, CloudIcon, ShieldCheckIcon, BoltIcon, CpuChipIcon, ServerIcon } from '@heroicons/react/24/outline'
import Link from 'next/link'

const plans = [
  {
    name: 'BASIC',
    price: '$19.88',
    period: 'month',
    features: [
      '2 CPU cores',
      '2 GB RAM',
      '40 GB SSD RAID 10',
      '1000 GB bandwidth'
    ],
    link: '/checkout?plan=vps-basic',
    popular: false
  },
  {
    name: 'STANDARD',
    price: '$29.88',
    period: 'month',
    features: [
      '4 CPU cores',
      '6 GB RAM',
      '120 GB SSD RAID 10',
      '3000 GB bandwidth'
    ],
    link: '/checkout?plan=vps-standard',
    popular: true
  },
  {
    name: 'PROFESSIONAL',
    price: '$48.88',
    period: 'month',
    features: [
      '8 CPU cores',
      '12 GB RAM',
      '240 GB SSD RAID 10',
      '6000 GB bandwidth'
    ],
    link: '/checkout?plan=vps-professional',
    popular: false
  },
  {
    name: 'PREMIUM',
    price: '$119.88',
    period: 'month',
    features: [
      '8 Core CPU Processor',
      '12 GB Guaranteed RAM',
      '300 GB RAID-10 SSD Storage',
      '6 TB Premium Bandwidth',
      '2 IP Addresses'
    ],
    link: '/checkout?plan=vps-premium',
    popular: false
  }
]

const features = [
  'Same-Day Setup',
  'Free Migration',
  '99.99% Uptime'
]

const webPanels = [
  {
    name: 'InterWorx',
    description: 'Features NodeWorx (to manage a server) and SiteWorx (to manage a website, mail hosting, and databases). Interworx makes it easy to migrate from other control panels such as SiteWorx, cPanel, DirectAdmin, Ensim, and Plesk 7-8.',
    features: [
      'Supports CentOS',
      'Allows for multiple Admin and User level access',
      'Includes unlimited accounts',
      'Fixed price of $18.00/month'
    ]
  },
  {
    name: 'cPanel',
    description: 'Simplify the management of your website hosting packages from one single dashboard. cPanel lets you upload and manage files, create email accounts, and check the statistics of your website (e.g. the amount of visitors).',
    features: [
      'Supports CentOS, CloudLinux and AlmaLinux',
      'Only allows for Admin access',
      'The number of accounts is dependent on the tiers',
      'Starts at $14.88/month for Solo tier'
    ]
  }
]

export default function VPSHostingPage() {
  return (
    <div className="min-h-screen bg-white">
      {/* Hero Section */}
      <section className="relative py-20 bg-slate-900">
        <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAwIDEwIEwgMjAgMTAgTSAxMCAwIEwgMTAgMjAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjA1IiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-10"></div>
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
            className="text-center"
          >
            <motion.span
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ delay: 0.2 }}
              className="inline-block px-4 py-2 rounded-full bg-blue-50 text-blue-600 text-sm font-semibold mb-4"
            >
              Enterprise VPS Hosting
            </motion.span>
            
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-4">
              VPS Hosting Solutions
            </h1>
            <p className="text-xl md:text-2xl text-slate-300 mb-2">
              Scalable virtual private servers
            </p>
            <p className="text-lg text-slate-400 mb-8">
              Fully managed hosting with dedicated resources
            </p>
            
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.4 }}
            >
              <Link
                href="/vps-hosting#plans"
                className="inline-block px-8 py-4 bg-white text-purple-600 rounded-lg font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-200"
              >
                ORDER NOW
              </Link>
            </motion.div>
          </motion.div>
        </div>
      </section>

      {/* Description Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto">
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ duration: 0.6 }}
            >
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">VPS HOSTING</h2>
              <p className="text-lg text-gray-700 leading-relaxed mb-4">
                VPS hosting is a type of web hosting services in lahore that provides customers with a virtualized, isolated environment on a shared physical VPS server. This allows customers to have their own cheap dedicated server resources (such as CPU, RAM, and storage) and the ability to install their own operating systems and applications.
              </p>
              <p className="text-lg text-gray-700 leading-relaxed mb-4">
                VPS hosting is a popular option for businesses and individuals who require more control and flexibility than traditional shared hosting, but do not want to invest in a dedicated server.
              </p>
              <p className="text-lg text-gray-700 leading-relaxed">
                VPS hosting is typically less expensive than dedicated server hosting, but more expensive than shared hosting. The customer will have administrative access to the virtualized environment and it is similar to having a dedicated server but with a shared hosting plan.
              </p>
            </motion.div>
          </div>
        </div>
      </section>

      {/* Pricing Plans */}
      <section className="py-16 bg-gradient-to-br from-gray-50 to-purple-50/30">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              HOSTING PACKAGES
            </h2>
            <p className="text-lg text-gray-600">WEB HOSTING COMPANY</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {plans.map((plan, index) => (
              <motion.div
                key={plan.name}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.1 }}
                className={`relative bg-white rounded-xl shadow-lg overflow-hidden ${
                  plan.popular ? 'ring-2 ring-purple-500 scale-105' : ''
                }`}
              >
                {plan.popular && (
                  <div className="absolute top-0 right-0 bg-purple-500 text-white px-4 py-1 text-sm font-semibold rounded-bl-lg">
                    POPULAR
                  </div>
                )}
                
                <div className="p-6">
                  <h3 className="text-2xl font-bold text-gray-900 mb-4">{plan.name}</h3>
                  <div className="mb-6">
                    <span className="text-4xl font-bold text-purple-600">{plan.price}</span>
                    <span className="text-gray-600"> / {plan.period}</span>
                  </div>
                  
                  <ul className="space-y-3 mb-8">
                    {plan.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start gap-2 text-gray-700">
                        <CheckIcon className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                        <span className="text-sm">{feature}</span>
                      </li>
                    ))}
                  </ul>
                  
                  <Link
                    href={plan.link}
                    className="block w-full py-3 bg-gradient-to-r from-purple-600 to-indigo-600 text-white text-center font-semibold rounded-lg hover:shadow-lg hover:-translate-y-0.5 transition-all duration-200"
                  >
                    Order Now
                  </Link>
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Pay Less Section */}
      <section className="py-16 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-8"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">PAY LESS</h2>
            <p className="text-lg text-gray-700 mb-6">
              Get more power and control with your own dedicated server, all for an affordable price.
            </p>
            <div className="flex flex-wrap justify-center gap-6 mb-6">
              {features.map((feature, index) => (
                <div key={index} className="flex items-center gap-2">
                  <CheckIcon className="w-5 h-5 text-green-500" />
                  <span className="text-gray-700 font-semibold">{feature}</span>
                </div>
              ))}
            </div>
            <div className="text-2xl font-bold text-purple-600">
              Start at $19.88<span className="text-lg">/month</span>
            </div>
          </motion.div>
        </div>
      </section>

      {/* Web Panels Section */}
      <section className="py-16 bg-gradient-to-br from-gray-50 to-purple-50/30">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
            className="text-center mb-12"
          >
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">WEB PANELS</h2>
            <p className="text-lg text-gray-600">VPS SERVER</p>
          </motion.div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
            {webPanels.map((panel, index) => (
              <motion.div
                key={panel.name}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ delay: index * 0.2 }}
                className="bg-white rounded-xl shadow-lg p-8"
              >
                <h3 className="text-2xl font-bold text-gray-900 mb-4">{panel.name}</h3>
                <p className="text-gray-700 leading-relaxed mb-6">{panel.description}</p>
                <ul className="space-y-3">
                  {panel.features.map((feature, idx) => (
                    <li key={idx} className="flex items-start gap-2 text-gray-700">
                      <CheckIcon className="w-5 h-5 text-purple-500 flex-shrink-0 mt-0.5" />
                      <span>{feature}</span>
                    </li>
                  ))}
                </ul>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-16 bg-gradient-to-br from-purple-600 via-violet-600 to-indigo-600">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <motion.div
            initial={{ opacity: 0, y: 20 }}
            whileInView={{ opacity: 1, y: 0 }}
            viewport={{ once: true }}
          >
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Ready for Ultimate Control?
            </h2>
            <p className="text-xl text-white/90 mb-8">
              Choose your perfect VPS hosting plan today
            </p>
            <Link
              href="/vps-hosting#plans"
              className="inline-block px-8 py-4 bg-white text-purple-600 rounded-lg font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-200"
            >
              Get Started Now
            </Link>
          </motion.div>
        </div>
      </section>
    </div>
  )
}
