'use client'

import { ShieldCheckIcon, CheckBadgeIcon, ClockIcon } from '@heroicons/react/24/outline'

interface CertificationBadge {
  name: string
  description: string
  icon?: any
}

const certifications: CertificationBadge[] = [
  {
    name: 'Microsoft Certified',
    description: 'Azure & Cloud Solutions',
    icon: ShieldCheckIcon
  },
  {
    name: 'AWS Certified',
    description: 'Amazon Web Services',
    icon: CheckBadgeIcon
  },
  {
    name: 'Google Partner',
    description: 'Cloud & Ads Expert',
    icon: ShieldCheckIcon
  },
  {
    name: '99.9% Uptime',
    description: 'SLA Guarantee',
    icon: ClockIcon
  }
]

interface CertificationBadgesProps {
  layout?: 'grid' | 'inline'
  className?: string
}

export default function CertificationBadges({ layout = 'inline', className = '' }: CertificationBadgesProps) {
  const containerClass = layout === 'grid' 
    ? 'grid grid-cols-2 md:grid-cols-4 gap-4' 
    : 'flex flex-wrap gap-4'

  return (
    <div className={`${containerClass} ${className}`}>
      {certifications.map((cert) => (
        <div
          key={cert.name}
          className="flex items-center gap-3 bg-slate-50 border border-slate-200 rounded-lg px-4 py-3"
        >
          {cert.icon && (
            <div className="w-8 h-8 bg-blue-50 rounded-lg flex items-center justify-center flex-shrink-0">
              <cert.icon className="w-5 h-5 text-blue-600" />
            </div>
          )}
          <div>
            <div className="font-semibold text-slate-900 text-sm">{cert.name}</div>
            <div className="text-xs text-slate-600">{cert.description}</div>
          </div>
        </div>
      ))}
    </div>
  )
}
