"use client";

import React from "react";
import PaymentForm from "./PaymentForm";

interface ClientPaymentFormWrapperProps {
  amount: number;
  currency: string;
  orderId: string;
  onSuccess: (paymentResult: any) => void;
  onError: (error: string) => void;
}

const ClientPaymentFormWrapper: React.FC<ClientPaymentFormWrapperProps> = ({
  amount,
  currency,
  orderId,
  onSuccess,
  onError,
}) => {
  return (
    <PaymentForm
      amount={amount}
      currency={currency}
      orderId={orderId}
      onSuccess={onSuccess}
      onError={onError}
    />
  );
};

export default ClientPaymentFormWrapper;