"use client";

import React from "react";
import ClientPaymentFormWrapper from "@/components/ClientPaymentFormWrapper";

interface ClientPaymentSectionProps {
  amount: number;
  currency: string;
  orderId: string;
  onSuccess: (paymentResult: any) => void;
  onError: (error: string) => void;
}

const ClientPaymentSection: React.FC<ClientPaymentSectionProps> = ({
  amount,
  currency,
  orderId,
  onSuccess,
  onError,
}) => {
  return (
    <div>
      <ClientPaymentFormWrapper
        amount={amount}
        currency={currency}
        orderId={orderId}
        onSuccess={onSuccess}
        onError={onError}
      />
    </div>
  );
};

export default ClientPaymentSection;