import Link from 'next/link'
import NoSSR from './NoSSR'
import NuwairLogo from './NuwairLogo'
import { 
  EnvelopeIcon, 
  PhoneIcon, 
  MapPinIcon
} from '@heroicons/react/24/outline'

const navigation = {
  services: [
    { name: 'Web Hosting', href: '/services/hosting' },
    { name: 'Domain Registration', href: '/services/domains' },
    { name: 'VPS Hosting', href: '/services/vps' },
    { name: 'Dedicated Servers', href: '/services/dedicated' },
    { name: 'Cloud Hosting', href: '/services/cloud' },
    { name: 'Email Hosting', href: '/services/email' },
  ],
  company: [
    { name: 'About Us', href: '/about' },
    { name: 'Portfolio', href: '/portfolio' },
    { name: 'Our Team', href: '/team' },
    { name: 'Careers', href: '/careers' },
    { name: 'Press', href: '/press' },
    { name: 'Contact', href: '/contact' },
  ],
  support: [
    { name: 'Help Center', href: '/help' },
    { name: 'Knowledge Base', href: '/kb' },
    { name: 'System Status', href: '/status' },
    { name: 'Support Portal', href: '/support' },
    { name: 'Submit Ticket', href: '/ticket' },
    { name: 'Live Chat', href: '/chat' },
  ],
  solutions: [
    { name: 'WordPress Hosting', href: '/wordpress' },
    { name: 'E-commerce', href: '/ecommerce' },
    { name: 'Business Email', href: '/business-email' },
    { name: 'Website Builder', href: '/website-builder' },
    { name: 'SSL Certificates', href: '/ssl' },
    { name: 'Backup Services', href: '/backup' },
  ],
  legal: [
    { name: 'Terms of Service', href: '/terms' },
    { name: 'Privacy Policy', href: '/privacy' },
    { name: 'SLA Agreement', href: '/sla' },
    { name: 'Cookie Policy', href: '/cookies' },
    { name: 'Data Protection', href: '/gdpr' },
    { name: 'Acceptable Use', href: '/aup' },
  ],
}

const socialLinks = [
  {
    name: 'Facebook',
    href: 'https://www.facebook.com/nuwairsystems',
    icon: (props: any) => (
      <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
        <path
          fillRule="evenodd"
          d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z"
          clipRule="evenodd"
        />
      </svg>
    ),
  },
  {
    name: 'Instagram',
    href: 'https://www.instagram.com/nuwairsystems/',
    icon: (props: any) => (
      <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
        <path
          fillRule="evenodd"
          d="M12.017 0C8.396 0 7.929.01 6.71.048 5.498.087 4.79.22 4.156.42a3.917 3.917 0 0 0-1.417.923A3.927 3.927 0 0 0 1.815 2.76C1.612 3.391 1.482 4.099 1.448 5.316.01 6.535 0 7.003 0 10.624s.01 4.09.048 5.309c.04 1.217.171 1.925.372 2.556a3.917 3.917 0 0 0 .923 1.417 3.896 3.896 0 0 0 1.417.923c.633.203 1.34.333 2.557.372 1.218.04 1.686.05 5.307.05s4.09-.01 5.307-.05c1.217-.04 1.925-.169 2.557-.372a3.896 3.896 0 0 0 1.417-.923 3.917 3.917 0 0 0 .923-1.417c.203-.633.333-1.34.372-2.557.04-1.218.05-1.686.05-5.307s-.01-4.09-.05-5.307c-.04-1.217-.169-1.925-.372-2.557a3.917 3.917 0 0 0-.923-1.417A3.896 3.896 0 0 0 18.982 1.172c-.633-.203-1.34-.333-2.557-.372C15.207.01 14.739 0 11.117 0h.9zm-.056 2.25c3.555 0 3.975.014 5.38.052 1.297.059 2.003.274 2.472.456.62.24 1.064.528 1.532.996.468.468.756.912.997 1.532.181.469.397 1.175.456 2.472.038 1.405.052 1.825.052 5.38s-.014 3.975-.052 5.38c-.059 1.297-.274 2.003-.456 2.472a4.147 4.147 0 0 1-.997 1.532 4.147 4.147 0 0 1-1.532.997c-.469.181-1.175.397-2.472.456-1.405.038-1.825.052-5.38.052s-3.975-.014-5.38-.052c-1.297-.059-2.003-.274-2.472-.456a4.147 4.147 0 0 1-1.532-.997 4.147 4.147 0 0 1-.997-1.532c-.181-.469-.397-1.175-.456-2.472-.038-1.405-.052-1.825-.052-5.38s.014-3.975.052-5.38c.059-1.297.274-2.003.456-2.472.24-.62.528-1.064.997-1.532a4.147 4.147 0 0 1 1.532-.997c.469-.181 1.175-.397 2.472-.456 1.405-.038 1.825-.052 5.38-.052z"
          clipRule="evenodd"
        />
        <path
          fillRule="evenodd"
          d="M12.017 15.33a3.33 3.33 0 1 1 0-6.66 3.33 3.33 0 0 1 0 6.66zm0-8.493a5.163 5.163 0 1 0 0 10.326 5.163 5.163 0 0 0 0-10.326zm6.532-1.308a1.2 1.2 0 1 1-2.4 0 1.2 1.2 0 0 1 2.4 0z"
          clipRule="evenodd"
        />
      </svg>
    ),
  },
  {
    name: 'Twitter',
    href: 'https://twitter.com/nuwairsystems',
    icon: (props: any) => (
      <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
        <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84" />
      </svg>
    ),
  },
  {
    name: 'LinkedIn',
    href: 'https://www.linkedin.com/company/nuwairsystems',
    icon: (props: any) => (
      <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
        <path
          fillRule="evenodd"
          d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"
          clipRule="evenodd"
        />
      </svg>
    ),
  },
  {
    name: 'YouTube',
    href: 'https://www.youtube.com/nuwairsystems',
    icon: (props: any) => (
      <svg fill="currentColor" viewBox="0 0 24 24" {...props}>
        <path
          fillRule="evenodd"
          d="M19.812 5.418c.861.23 1.538.907 1.768 1.768C21.998 8.746 22 12 22 12s0 3.255-.418 4.814a2.504 2.504 0 0 1-1.768 1.768c-1.56.419-7.814.419-7.814.419s-6.255 0-7.814-.419a2.505 2.505 0 0 1-1.768-1.768C2 15.255 2 12 2 12s0-3.255.417-4.814a2.507 2.507 0 0 1 1.768-1.768C5.744 5 11.998 5 11.998 5s6.255 0 7.814.418ZM15.194 12 10 15V9l5.194 3Z"
          clipRule="evenodd"
        />
      </svg>
    ),
  },
]

export default function Footer() {
  return (
    <footer className="relative bg-slate-900 border-t border-slate-800" aria-labelledby="footer-heading" suppressHydrationWarning>
      <h2 id="footer-heading" className="sr-only">
        Footer
      </h2>
      <div className="mx-auto max-w-7xl px-6 pb-8 pt-12 sm:pt-16 lg:px-8 lg:pt-20" suppressHydrationWarning>
        <div className="xl:grid xl:grid-cols-3 xl:gap-8" suppressHydrationWarning>
          <div className="space-y-8" suppressHydrationWarning>
            {/* Corporate Logo */}
            <div className="flex items-center p-4 rounded-lg bg-white shadow-sm" suppressHydrationWarning>
              <NuwairLogo 
                variant="default"
                className="transition-all duration-300 hover:scale-105" 
                width={200} 
                height={60}
              />
            </div>
            <p className="text-sm leading-6 text-slate-400">
              Enterprise IT solutions provider delivering innovative technology, hosting services, 
              and digital transformation for businesses worldwide. Trusted by 1,000+ clients.
            </p>
            
            {/* Contact info */}
            <div className="space-y-3" suppressHydrationWarning>
              <div className="flex items-center space-x-3" suppressHydrationWarning>
                <EnvelopeIcon className="h-5 w-5 text-blue-400" />
                <span className="text-sm text-slate-300 font-medium">sales@nuwair.com</span>
              </div>
              <div className="flex items-center space-x-3" suppressHydrationWarning>
                <PhoneIcon className="h-5 w-5 text-blue-400" />
                <span className="text-sm text-slate-300 font-medium">+92 3111 689 247</span>
              </div>
              <div className="flex items-center space-x-3" suppressHydrationWarning>
                <MapPinIcon className="h-5 w-5 text-blue-400" />
                <span className="text-sm text-slate-400">49 Main Shadman Market Rd, Lahore, Pakistan</span>
              </div>
            </div>
            
            {/* Social links */}
            <div className="flex space-x-6" suppressHydrationWarning>
              {socialLinks.map((item) => (
                <a
                  key={item.name}
                  href={item.href}
                  className="text-slate-400 hover:text-blue-400 transition-colors"
                >
                  <span className="sr-only">{item.name}</span>
                  <item.icon className="h-6 w-6" aria-hidden="true" />
                </a>
              ))}
            </div>
          </div>
          
          <div className="mt-16 grid grid-cols-2 gap-8 xl:col-span-2 xl:mt-0" suppressHydrationWarning>
            <div className="md:grid md:grid-cols-2 md:gap-8" suppressHydrationWarning>
              <div suppressHydrationWarning>
                <h3 className="text-sm font-semibold leading-6 text-white">Hosting Services</h3>
                <ul className="mt-6 space-y-4">
                  {navigation.services.map((item) => (
                    <li key={item.name}>
                      <Link
                        href={item.href}
                        className="text-sm leading-6 text-slate-400 hover:text-blue-400 transition-colors"
                      >
                        {item.name}
                      </Link>
                    </li>
                  ))}
                </ul>
              </div>
              <div className="mt-10 md:mt-0" suppressHydrationWarning>
                <h3 className="text-sm font-semibold leading-6 text-white">Solutions</h3>
                <ul className="mt-6 space-y-4">
                  {navigation.solutions.map((item) => (
                    <li key={item.name}>
                      <Link
                        href={item.href}
                        className="text-sm leading-6 text-slate-400 hover:text-blue-400 transition-colors"
                      >
                        {item.name}
                      </Link>
                    </li>
                  ))}
                </ul>
              </div>
            </div>
            <div className="md:grid md:grid-cols-2 md:gap-8" suppressHydrationWarning>
              <div suppressHydrationWarning>
                <h3 className="text-sm font-semibold leading-6 text-white">Company</h3>
                <ul className="mt-6 space-y-4">
                  {navigation.company.map((item) => (
                    <li key={item.name}>
                      <Link
                        href={item.href}
                        className="text-sm leading-6 text-slate-400 hover:text-blue-400 transition-colors"
                      >
                        {item.name}
                      </Link>
                    </li>
                  ))}
                </ul>
              </div>
              <div className="mt-10 md:mt-0" suppressHydrationWarning>
                <h3 className="text-sm font-semibold leading-6 text-white">Support</h3>
                <ul className="mt-6 space-y-4">
                  {navigation.support.map((item) => (
                    <li key={item.name}>
                      <Link
                        href={item.href}
                        className="text-sm leading-6 text-slate-400 hover:text-blue-400 transition-colors"
                      >
                        {item.name}
                      </Link>
                    </li>
                  ))}
                </ul>
              </div>
            </div>
          </div>
        </div>
        
        {/* Newsletter */}
        <div className="mt-8 border-t border-slate-800 pt-8" suppressHydrationWarning>
          <div className="flex flex-col lg:flex-row lg:items-center lg:justify-between" suppressHydrationWarning>
            <div suppressHydrationWarning>
              <h3 className="text-sm font-semibold leading-6 text-white">
                Subscribe to our newsletter
              </h3>
              <p className="mt-2 text-sm leading-6 text-slate-400">
                Stay updated with the latest insights and industry news.
              </p>
            </div>
            <NoSSR>
              <form className="mt-6 lg:mt-0 lg:flex lg:max-w-md">
                <label htmlFor="email-address" className="sr-only">
                  Email address
                </label>
                <input
                  id="email-address"
                  name="email"
                  type="email"
                  autoComplete="email"
                  required
                  className="w-full min-w-0 appearance-none rounded-lg border border-slate-700 bg-slate-800 px-4 py-2.5 text-base text-white placeholder:text-slate-500 focus:border-blue-500 focus:outline-none focus:ring-2 focus:ring-blue-500 sm:w-64 sm:text-sm sm:leading-6 xl:w-full"
                  placeholder="Enter your email"
                />
                <div className="mt-4 lg:ml-4 lg:mt-0 lg:flex-shrink-0">
                  <button
                    type="submit"
                    className="flex w-full items-center justify-center rounded-lg bg-blue-600 px-6 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-blue-700 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-blue-600 transition-colors"
                  >
                    Subscribe
                  </button>
                </div>
              </form>
            </NoSSR>
          </div>
        </div>
        
        {/* Bottom section */}
        <div className="mt-8 border-t border-slate-800 pt-8" suppressHydrationWarning>
          <div className="md:flex md:items-center md:justify-between" suppressHydrationWarning>
            <div className="flex flex-col md:flex-row md:items-center space-y-4 md:space-y-0 md:space-x-8" suppressHydrationWarning>
              <p className="text-xs leading-5 text-slate-500">
                &copy; 2025 Nuwair Systems. All rights reserved.
              </p>
              <div className="flex items-center space-x-6 text-xs text-slate-500" suppressHydrationWarning>
                <span className="flex items-center">
                  <span className="mr-2">🇵🇰</span> Pakistan Based
                </span>
                <span>•</span>
                <span>Microsoft & AWS Certified</span>
                <span>•</span>
                <span>99.9% SLA Guarantee</span>
              </div>
            </div>
            <div className="mt-4 md:mt-0" suppressHydrationWarning>
              <div className="flex items-center space-x-4" suppressHydrationWarning>
                <div className="flex items-center space-x-2 text-xs text-slate-500" suppressHydrationWarning>
                  <div className="w-2 h-2 bg-green-500 rounded-full animate-pulse" suppressHydrationWarning></div>
                  <span>All Systems Operational</span>
                </div>
                <a
                  href="/status"
                  className="text-xs text-slate-500 hover:text-blue-400 transition-colors"
                >
                  Status Page
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  )
}
