"use client";

import React, { useState } from 'react';

interface SidebarProps {
  tabs: string[];
  activeTab: string;
}

const Sidebar: React.FC<Omit<SidebarProps, 'setActiveTab'>> = ({ tabs, activeTab: initialActiveTab }) => {
  const [activeTab, setActiveTab] = useState(initialActiveTab);

  return (
    <div className="w-64 bg-gray-800 text-white h-screen p-4">
      <h2 className="text-xl font-bold mb-6">Admin Dashboard</h2>
      <ul className="space-y-4">
        {tabs.map((tab) => (
          <li key={tab}>
            <button
              className={`w-full text-left px-4 py-2 rounded-lg ${
                activeTab === tab ? 'bg-gray-700' : 'hover:bg-gray-700'
              }`}
              onClick={() => setActiveTab(tab)}
            >
              {tab}
            </button>
          </li>
        ))}
      </ul>
    </div>
  );
};

export default Sidebar;