'use client'

import { motion } from 'framer-motion'

interface Stat {
  value: string
  label: string
  suffix?: string
}

const defaultStats: Stat[] = [
  { value: '15', label: 'Years Experience', suffix: '+' },
  { value: '1,000', label: 'Active Clients', suffix: '+' },
  { value: '50', label: 'Countries Served', suffix: '+' },
  { value: '99.9', label: 'Uptime SLA', suffix: '%' }
]

interface StatsGridProps {
  stats?: Stat[]
  variant?: 'light' | 'dark'
  className?: string
}

export default function StatsGrid({ 
  stats = defaultStats, 
  variant = 'light',
  className = '' 
}: StatsGridProps) {
  const isDark = variant === 'dark'
  
  return (
    <div className={`grid grid-cols-2 md:grid-cols-4 gap-6 ${className}`}>
      {stats.map((stat, index) => (
        <motion.div
          key={stat.label}
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ delay: index * 0.1 }}
          className={`text-center p-6 rounded-xl border ${
            isDark 
              ? 'bg-slate-800 border-slate-700' 
              : 'bg-white border-slate-200'
          }`}
        >
          <div className={`text-4xl font-bold mb-2 ${
            isDark ? 'text-white' : 'text-slate-900'
          }`}>
            {stat.value}{stat.suffix}
          </div>
          <div className={`text-sm font-semibold ${
            isDark ? 'text-slate-400' : 'text-slate-600'
          }`}>
            {stat.label}
          </div>
        </motion.div>
      ))}
    </div>
  )
}
