'use client'

import { motion } from 'framer-motion'
import { ShieldCheckIcon, ClockIcon, GlobeAltIcon } from '@heroicons/react/24/outline'

interface TrustBadgesProps {
  variant?: 'horizontal' | 'vertical'
  className?: string
}

export default function TrustBadges({ variant = 'horizontal', className = '' }: TrustBadgesProps) {
  const badges = [
    {
      icon: ShieldCheckIcon,
      text: 'Microsoft Certified',
      color: 'blue'
    },
    {
      icon: ClockIcon,
      text: '99.9% Uptime SLA',
      color: 'blue'
    },
    {
      icon: GlobeAltIcon,
      text: 'AWS Certified',
      color: 'blue'
    }
  ]

  const containerClass = variant === 'horizontal' 
    ? 'flex flex-wrap items-center gap-6' 
    : 'flex flex-col gap-4'

  return (
    <div className={`${containerClass} ${className}`}>
      {badges.map((badge, index) => (
        <motion.div
          key={badge.text}
          initial={{ opacity: 0, y: 10 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ delay: index * 0.1 }}
          className="flex items-center gap-2"
        >
          <div className="w-8 h-8 bg-blue-50 rounded-lg flex items-center justify-center">
            <badge.icon className="w-5 h-5 text-blue-600" />
          </div>
          <span className="text-sm font-semibold text-slate-700">{badge.text}</span>
        </motion.div>
      ))}
    </div>
  )
}
