'use client'

import { motion } from 'framer-motion'
import { 
  CheckCircleIcon, 
  LightBulbIcon, 
  ShieldCheckIcon, 
  RocketLaunchIcon,
  UserGroupIcon,
  GlobeAltIcon
} from '@heroicons/react/24/outline'

const features = [
  {
    icon: LightBulbIcon,
    title: 'Innovation First',
    description: 'We leverage cutting-edge technologies and innovative approaches to deliver solutions that keep you ahead of the competition.'
  },
  {
    icon: ShieldCheckIcon,
    title: 'Security & Reliability',
    description: 'Your data security is our priority. We implement robust security measures and ensure 99.9% uptime across all our services.'
  },
  {
    icon: UserGroupIcon,
    title: 'Expert Team',
    description: 'Our team of certified professionals brings years of experience in web development, digital marketing, and IT consulting.'
  },
  {
    icon: RocketLaunchIcon,
    title: 'Fast Delivery',
    description: 'We understand the importance of time-to-market. Our streamlined processes ensure quick turnaround without compromising quality.'
  },
  {
    icon: GlobeAltIcon,
    title: 'Global Reach',
    description: 'Serving clients worldwide with localized support and understanding of different markets and business cultures.'
  },
  {
    icon: CheckCircleIcon,
    title: '24/7 Support',
    description: 'Round-the-clock technical support and customer service to ensure your business operations run smoothly at all times.'
  }
]

const containerVariants = {
  hidden: { opacity: 0 },
  visible: {
    opacity: 1,
    transition: {
      staggerChildren: 0.1
    }
  }
}

const itemVariants = {
  hidden: { opacity: 0, y: 20 },
  visible: {
    opacity: 1,
    y: 0,
    transition: { duration: 0.5 }
  }
}

export default function About() {
  return (
    <section id="about" className="py-20">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="lg:grid lg:grid-cols-2 lg:gap-12 lg:items-start">
          {/* Left column - Content */}
          <motion.div
            initial={{ opacity: 0, x: -20 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.6 }}
            className="mb-12 lg:mb-0"
          >
            <h2 className="text-4xl font-bold text-gray-900 mb-6 font-heading">
              About <span className="text-gradient">Nuwair Systems</span>
            </h2>
            <p className="text-lg text-gray-600 mb-8 leading-relaxed">
              With over 8 years of experience in the IT industry, Nuwair Systems has established itself 
              as a trusted partner for businesses looking to thrive in the digital landscape. We combine 
              technical expertise with creative innovation to deliver solutions that drive real results.
            </p>
            <p className="text-lg text-gray-600 mb-8 leading-relaxed">
              From startups to enterprise-level organizations, we've helped over 500 clients transform 
              their digital presence and achieve their business goals through our comprehensive IT services.
            </p>
            
            {/* Key metrics */}
            <div className="grid grid-cols-2 gap-6 mb-8">
              <div>
                <div className="text-2xl font-bold text-blue-600 mb-1">8+</div>
                <div className="text-gray-600">Years of Experience</div>
              </div>
              <div>
                <div className="text-2xl font-bold text-blue-600 mb-1">500+</div>
                <div className="text-gray-600">Happy Clients</div>
              </div>
            </div>

            <motion.button
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
              className="bg-blue-600 hover:bg-blue-700 text-white px-8 py-3 rounded-lg font-semibold transition-colors duration-200"
            >
              Learn More About Us
            </motion.button>
          </motion.div>

          {/* Right column - Features */}
          <motion.div
            variants={containerVariants}
            initial="hidden"
            whileInView="visible"
            viewport={{ once: true }}
            className="mt-12 lg:mt-0"
          >
            <div className="grid grid-cols-1 gap-3">
              {features.map((feature, index) => {
                const Icon = feature.icon
                return (
                  <motion.div
                    key={feature.title}
                    variants={itemVariants}
                    className="flex items-start space-x-3 p-3 rounded-lg hover:bg-gray-50 transition-colors duration-200"
                  >
                    <div className="flex-shrink-0">
                      <div className="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                        <Icon className="w-4 h-4 text-blue-600" />
                      </div>
                    </div>
                    <div>
                      <h3 className="text-lg font-semibold text-gray-900 mb-1">
                        {feature.title}
                      </h3>
                      <p className="text-gray-600 leading-relaxed">
                        {feature.description}
                      </p>
                    </div>
                  </motion.div>
                )
              })}
            </div>
          </motion.div>
        </div>
      </div>
    </section>
  )
}