'use client'

import { motion } from 'framer-motion'
import { ArrowRightIcon, CheckCircleIcon, ShieldCheckIcon, ClockIcon, GlobeAltIcon, UsersIcon, ChartBarIcon } from '@heroicons/react/24/solid'
import Link from 'next/link'

const fadeInUp = {
  initial: { opacity: 0, y: 30 },
  animate: { opacity: 1, y: 0 },
  transition: { duration: 0.5, ease: "easeOut" }
}

const staggerContainer = {
  animate: {
    transition: {
      staggerChildren: 0.1,
      delayChildren: 0.1
    }
  }
}

export default function Hero() {
  return (
    <section className="relative bg-gradient-to-b from-[#f5f7ff] to-white overflow-hidden border-b border-slate-200">
      {/* Subtle background pattern */}
      <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSI2MCIgaGVpZ2h0PSI2MCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAxMCAwIEwgMTAgNjAgTSAwIDEwIEwgNjAgMTAgTSAyMCAwIEwgMjAgNjAgTSAwIDIwIEwgNjAgMjAgTSAzMCAwIEwgMzAgNjAgTSAwIDMwIEwgNjAgMzAgTSA0MCAwIEwgNDAgNjAgTSAwIDQwIEwgNjAgNDAgTSA1MCAwIEwgNTAgNjAgTSAwIDUwIEwgNjAgNTAiIGZpbGw9Im5vbmUiIHN0cm9rZT0iIzAwMDAwMCIgc3Ryb2tlLW9wYWNpdHk9IjAuMDIiIHN0cm9rZS13aWR0aD0iMSIvPjwvcGF0dGVybj48L2RlZnM+PHJlY3Qgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgZmlsbD0idXJsKCNncmlkKSIvPjwvc3ZnPg==')] opacity-40"></div>

      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-16 pb-10 lg:pt-24 lg:pb-16">
        <div className="flex flex-col items-center text-center">
          {/* Top badge */}
          <motion.div
            variants={fadeInUp}
            initial="initial"
            animate="animate"
            className="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-blue-50 border border-blue-200 mb-4"
          >
            <ShieldCheckIcon className="w-4 h-4 text-blue-600" />
            <span className="text-sm font-semibold text-slate-900">Microsoft & AWS Certified Professionals • Since 2010</span>
          </motion.div>

          {/* Main Headline */}
          <motion.h1
            variants={fadeInUp}
            initial="initial"
            animate="animate"
            className="text-4xl md:text-5xl lg:text-6xl font-bold mb-4 leading-[1.1]"
          >
            <span className="block text-slate-900">Transform Your Business</span>
            <span className="block text-purple-600 mt-2">Into a <span className="text-blue-600">Digital</span> Powerhouse</span>
          </motion.h1>

          {/* Subheadline */}
          <motion.p
            variants={fadeInUp}
            initial="initial"
            animate="animate"
            className="text-lg md:text-xl text-slate-600 mb-8 leading-relaxed max-w-2xl mx-auto"
          >
            Step into industry dominance with expertly crafted, powerful web solutions, innovative design, secure hosting, and AI-powered business growth. Elevate your brand, boost sales, and outpace your competition.
          </motion.p>

          {/* CTA Row: Domain search and consultation */}
          <motion.div
            variants={fadeInUp}
            initial="initial"
            animate="animate"
            className="flex flex-col sm:flex-row gap-4 w-full max-w-2xl mx-auto mb-8"
          >
            <input
              type="text"
              placeholder="Enter your domain name..."
              className="flex-1 px-5 py-4 rounded-lg border border-slate-300 text-base focus:outline-none focus:ring-2 focus:ring-blue-200 shadow-sm"
            />
            <Link
              href="/contact"
              className="inline-flex items-center justify-center gap-2 px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-base shadow-md hover:bg-blue-700 hover:shadow-lg transition-all duration-200"
            >
              <span>Get Free Consultation</span>
              <ArrowRightIcon className="w-5 h-5 group-hover:translate-x-1 transition-transform" />
            </Link>
          </motion.div>

          {/* Stats Bar */}
          <motion.div
            variants={fadeInUp}
            initial="initial"
            animate="animate"
            className="w-full max-w-3xl mx-auto grid grid-cols-2 sm:grid-cols-4 gap-4 bg-white/80 border border-slate-200 rounded-xl shadow p-4"
          >
            <div className="flex flex-col items-center">
              <span className="text-xl font-bold text-blue-700">500+</span>
              <span className="text-xs text-slate-600 font-medium mt-1">Businesses</span>
            </div>
            <div className="flex flex-col items-center">
              <span className="text-xl font-bold text-purple-700">99.9%</span>
              <span className="text-xs text-slate-600 font-medium mt-1">Uptime</span>
            </div>
            <div className="flex flex-col items-center">
              <span className="text-xl font-bold text-green-700">24/7</span>
              <span className="text-xs text-slate-600 font-medium mt-1">Support</span>
            </div>
            <div className="flex flex-col items-center">
              <span className="text-xl font-bold text-orange-600">10X</span>
              <span className="text-xs text-slate-600 font-medium mt-1">Growth Potential</span>
            </div>
          </motion.div>
        </div>
      </div>
    </section>
  )
}