'use client'

import { motion } from 'framer-motion'
import { CheckCircleIcon } from '@heroicons/react/24/solid'

export default function Stats() {
  return (
    <section className="py-20 bg-gradient-to-b from-white to-blue-50/30 border-y border-slate-200">
      <div className="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.5 }}
        >
          <h2 className="text-3xl md:text-4xl font-bold text-slate-900 mb-6">
            Secure Your Dream Domain <span className="text-blue-600">Before Your Competitors Do!</span>
          </h2>
          <div className="flex flex-col sm:flex-row gap-4 justify-center mb-8 w-full max-w-xl mx-auto">
            <input
              type="text"
              placeholder="Search your domain..."
              className="flex-1 px-5 py-4 rounded-lg border border-slate-300 text-base focus:outline-none focus:ring-2 focus:ring-blue-200 shadow-sm"
            />
            <button className="inline-flex items-center justify-center gap-2 px-8 py-4 bg-blue-600 text-white rounded-lg font-semibold text-base shadow-md hover:bg-blue-700 hover:shadow-lg transition-all duration-200">
              <span>Check Availability</span>
            </button>
          </div>
          <div className="flex flex-wrap justify-center gap-4 mb-2">
            <div className="flex items-center gap-2 px-4 py-2 bg-slate-50 border border-slate-200 rounded-lg">
              <CheckCircleIcon className="w-4 h-4 text-green-600" />
              <span className="text-sm font-medium text-slate-700">Free SSL Certificate</span>
            </div>
            <div className="flex items-center gap-2 px-4 py-2 bg-slate-50 border border-slate-200 rounded-lg">
              <CheckCircleIcon className="w-4 h-4 text-green-600" />
              <span className="text-sm font-medium text-slate-700">Free Email Forwarding</span>
            </div>
            <div className="flex items-center gap-2 px-4 py-2 bg-slate-50 border border-slate-200 rounded-lg">
              <CheckCircleIcon className="w-4 h-4 text-green-600" />
              <span className="text-sm font-medium text-slate-700">24/7 Support</span>
            </div>
          </div>
        </motion.div>
      </div>
    </section>
  )
}