'use client'

import { motion } from 'framer-motion'

const partners = [
  {
    name: 'CloudLinux',
    logo: '/images/partners/cloudlinux.svg',
    description: 'Enterprise-grade Linux OS for web hosting'
  },
  {
    name: 'cPanel',
    logo: '/images/partners/cpanel.svg',
    description: 'Industry-leading web hosting control panel'
  },
  {
    name: 'Microsoft',
    logo: '/images/partners/microsoft.svg',
    description: 'Enterprise cloud solutions and productivity tools'
  },
  {
    name: 'Google',
    logo: '/images/partners/google.svg',
    description: 'Cloud infrastructure and workspace solutions'
  },
  {
    name: 'WordPress',
    logo: '/images/partners/wordpress.svg',
    description: 'World\'s most popular content management system'
  },
  {
    name: 'Cloudflare',
    logo: '/images/partners/cloudflare.svg',
    description: 'Global CDN and security services'
  },
  {
    name: 'Intel',
    logo: '/images/partners/intel.svg',
    description: 'High-performance server processors'
  },
  {
    name: 'SSD Servers',
    logo: '/images/partners/ssd.svg',
    description: 'Ultra-fast NVMe SSD storage solutions'
  }
]

const container = {
  hidden: { opacity: 0 },
  show: {
    opacity: 1,
    transition: {
      staggerChildren: 0.1
    }
  }
}

const item = {
  hidden: { opacity: 0, y: 20 },
  show: { opacity: 1, y: 0 }
}

export default function TrustedPartners() {
  return (
    <section className="py-20 bg-gray-50" suppressHydrationWarning>
      <div className="container mx-auto px-4">
        {/* Section Header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.6 }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl font-bold text-gray-900 mb-4">
            Trusted by Industry Leaders
          </h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            We partner with the world's leading technology companies to deliver 
            enterprise-grade hosting solutions you can trust
          </p>
        </motion.div>

        {/* Partners Grid */}
        <motion.div
          variants={container}
          initial="hidden"
          whileInView="show"
          viewport={{ once: true }}
          className="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-4 gap-8 mb-16"
        >
          {partners.map((partner, index) => (
            <motion.div
              key={partner.name}
              variants={item}
              whileHover={{ 
                scale: 1.05,
                transition: { duration: 0.2 }
              }}
              className="group bg-white rounded-xl p-8 shadow-sm hover:shadow-lg transition-all duration-300 border border-gray-100"
            >
              <div className="flex flex-col items-center text-center">
                {/* Partner Logo Placeholder */}
                <div className="w-20 h-20 mb-4 rounded-lg bg-gradient-to-br from-blue-50 to-blue-100 flex items-center justify-center group-hover:from-blue-100 group-hover:to-blue-200 transition-all duration-300">
                  <div className="text-2xl font-bold text-blue-600">
                    {partner.name.charAt(0)}
                  </div>
                </div>
                
                <h3 className="text-lg font-semibold text-gray-900 mb-2">
                  {partner.name}
                </h3>
                
                <p className="text-sm text-gray-600 leading-relaxed">
                  {partner.description}
                </p>
              </div>
            </motion.div>
          ))}
        </motion.div>

        {/* Trust Stats */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.6, delay: 0.3 }}
          className="bg-white rounded-2xl p-8 shadow-sm border border-gray-100"
        >
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
            <div className="space-y-2">
              <div className="text-3xl font-bold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent">
                99.9%
              </div>
              <div className="text-gray-600 font-medium">Uptime Guarantee</div>
              <div className="text-sm text-gray-500">Backed by enterprise infrastructure</div>
            </div>
            
            <div className="space-y-2">
              <div className="text-3xl font-bold bg-gradient-to-r from-green-600 to-blue-600 bg-clip-text text-transparent">
                10+
              </div>
              <div className="text-gray-600 font-medium">Technology Partners</div>
              <div className="text-sm text-gray-500">Industry-leading solutions</div>
            </div>
            
            <div className="space-y-2">
              <div className="text-3xl font-bold bg-gradient-to-r from-purple-600 to-pink-600 bg-clip-text text-transparent">
                24/7
              </div>
              <div className="text-gray-600 font-medium">Enterprise Support</div>
              <div className="text-sm text-gray-500">Always available when you need us</div>
            </div>
          </div>
        </motion.div>

        {/* Call to Action */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.6, delay: 0.4 }}
          className="text-center mt-12"
        >
          <h3 className="text-2xl font-semibold text-gray-900 mb-4">
            Ready to experience enterprise-grade hosting?
          </h3>
          <p className="text-gray-600 mb-8 max-w-2xl mx-auto">
            Join thousands of businesses who trust Nuwair Systems for their hosting needs
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <motion.button
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
              className="px-8 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white rounded-lg font-semibold hover:from-blue-700 hover:to-purple-700 transition-all duration-300 shadow-lg hover:shadow-xl"
            >
              Get Started Today
            </motion.button>
            <motion.button
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
              className="px-8 py-3 border-2 border-gray-300 text-gray-700 rounded-lg font-semibold hover:border-blue-500 hover:text-blue-600 transition-all duration-300"
            >
              View Our Plans
            </motion.button>
          </div>
        </motion.div>
      </div>
    </section>
  )
}