'use client'

import { motion } from 'framer-motion'
import { 
  ShieldCheckIcon, 
  ClockIcon, 
  CpuChipIcon,
  UserGroupIcon,
  TrophyIcon,
  GlobeAltIcon,
  ChartBarIcon
} from '@heroicons/react/24/outline'

const whyChooseReasons = [
  {
    id: 1,
    icon: ShieldCheckIcon,
    title: 'Enterprise-Grade Security',
    description: 'Advanced security protocols, SSL certificates, and 24/7 monitoring to protect your digital assets.',
    stats: '99.9% Uptime'
  },
  {
    id: 2,
    icon: ClockIcon,
    title: '24/7 Expert Support',
    description: 'Round-the-clock technical support from certified professionals in Pakistan and globally.',
    stats: '<2min Response'
  },
  {
    id: 3,
    icon: CpuChipIcon,
    title: 'Cutting-Edge Technology',
    description: 'Latest technologies including SSD storage, CDN, and optimized servers for maximum performance.',
    stats: '10x Faster'
  },
  {
    id: 4,
    icon: UserGroupIcon,
    title: 'Trusted by 1,000+ Businesses',
    description: 'From startups to enterprises, companies across Pakistan trust us for their digital needs.',
    stats: '1,000+ Clients'
  },
  {
    id: 5,
    icon: TrophyIcon,
    title: 'Award-Winning Service',
    description: 'Recognized for excellence in IT services, customer satisfaction, and innovative solutions.',
    stats: 'Industry Leader'
  },
  {
    id: 6,
    icon: GlobeAltIcon,
    title: 'Local Expertise, Global Standards',
    description: 'Based in Lahore with deep understanding of Pakistani market needs and international quality.',
    stats: 'Global Reach'
  }
]


export default function WhyChooseUs() {
  return (
    <section className="py-20 bg-gradient-to-br from-indigo-50/50 via-purple-50/30 to-pink-50/30">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Section header */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.6 }}
          className="text-center mb-14"
        >
          <div className="inline-flex items-center px-4 py-2 bg-blue-50 border border-blue-200 rounded-lg mb-4">
            <span className="text-sm font-semibold text-blue-900">Why Choose <span className='text-purple-600'>Nuwair Systems</span></span>
          </div>
          <h2 className="text-4xl font-bold text-slate-900 mb-2">
            Why Choose <span className="text-blue-600">Nuwair Systems</span>
          </h2>
          <p className="text-lg text-slate-600 max-w-2xl mx-auto">
            Pakistan's Trusted IT Solution Partner. Advanced, secure, and reliable for your business.
          </p>
        </motion.div>

        {/* Reasons grid - pastel cards */}
        <motion.div
          initial={{ opacity: 0 }}
          whileInView={{ opacity: 1 }}
          viewport={{ once: true }}
          transition={{ duration: 0.8 }}
          className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16"
        >
          {whyChooseReasons.map((reason, index) => {
            const Icon = reason.icon
            // Assign pastel backgrounds for variety
            const pastelBg = [
              'bg-blue-50',
              'bg-green-50',
              'bg-purple-50',
              'bg-pink-50',
              'bg-yellow-50',
              'bg-cyan-50'
            ][index % 6]
            return (
              <motion.div
                key={reason.id}
                initial={{ opacity: 0, y: 30 }}
                whileInView={{ opacity: 1, y: 0 }}
                viewport={{ once: true }}
                transition={{ duration: 0.6, delay: index * 0.1 }}
                className={`rounded-2xl p-7 shadow-md hover:shadow-lg transition-shadow duration-300 border border-slate-200 ${pastelBg}`}
              >
                <div className="flex items-center gap-3 mb-4">
                  <div className="w-12 h-12 bg-white border border-slate-200 rounded-xl flex items-center justify-center shadow">
                    <Icon className="w-6 h-6 text-blue-600" />
                  </div>
                  <div className="text-xs font-bold px-3 py-1 bg-blue-600 text-white rounded-full">
                    {reason.stats}
                  </div>
                </div>
                <h3 className="text-lg font-bold text-slate-900 mb-2">
                  {reason.title}
                </h3>
                <p className="text-slate-600 text-sm">
                  {reason.description}
                </p>
              </motion.div>
            )
          })}
        </motion.div>

        {/* CTA section - dark background */}
        <motion.div
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          transition={{ duration: 0.6, delay: 0.3 }}
          className="text-center"
        >
          <div className="bg-gradient-to-r from-blue-900 via-blue-800 to-purple-900 rounded-2xl p-12 border border-slate-900/10 shadow-xl">
            <h3 className="text-3xl md:text-4xl font-bold text-white mb-4">
              Ready to <span className="text-blue-300">10X Your Business?</span>
            </h3>
            <p className="text-lg text-blue-100 mb-8 max-w-2xl mx-auto">
              Step boldly forward with a partner that delivers results. Get a free consultation and discover how we can help you grow.
            </p>
            <button className="bg-white text-blue-700 hover:bg-blue-100 px-10 py-4 rounded-lg font-semibold text-lg transition-colors duration-300 shadow-md">
              Get Free Consultation
            </button>
          </div>
        </motion.div>
      </div>
    </section>
  )
}