'use client'

import { useEffect, useState } from 'react'

/**
 * Hook to ensure component only renders on client-side
 * Useful for preventing hydration mismatches
 */
export function useClientOnly() {
  const [isClient, setIsClient] = useState(false)

  useEffect(() => {
    setIsClient(true)
  }, [])

  return isClient
}

/**
 * Hook specifically for forms to avoid browser extension interference
 */
export function useFormHydration() {
  const [isHydrated, setIsHydrated] = useState(false)

  useEffect(() => {
    // Small delay to ensure browser extensions have loaded
    const timeout = setTimeout(() => {
      setIsHydrated(true)
    }, 100)

    return () => clearTimeout(timeout)
  }, [])

  return isHydrated
}