'use client'

import { useState, useEffect } from 'react'

export function useHydrationSafe() {
  const [isHydrated, setIsHydrated] = useState(false)

  useEffect(() => {
    // Mark as hydrated after the first render
    setIsHydrated(true)
  }, [])

  return isHydrated
}

export default useHydrationSafe